% takes a pos file and the indexed cluster pos file and generates a pos
% file with each cluster lined up ordered by composition
% every ion in the original pos file which is clustered. Clustered ions are
% labelled with their cluster ID and unclustered ions are 0
f = 'C:\Users\Andy\APT\R14_17053\recons\recon-v01\default\R14_17053-v01.cluster.indexed.rrng';
cf = 'C:\Users\Andy\APT\clusterAnalysis\R14_17053-v01.csv';
[mat,idx]=regexp(f,'[\w\\\:\s\-\.]+(?<=\-v0\d)');
p = strcat(f(1:idx(1)),'.pos'); % rename with .pos
c = regexprep(f,'.rrng','.pos'); % rename with .clustered.indexed.pos
% get cluster details
[elements,countsDecomp,counts,position,~,radii,extents,~,~,~,~,~,~,~,~,~,count] = clusterSizes(cf);
ytiratio = countsDecomp(:,strcmp(elements,'Y'))./countsDecomp(:,strcmp(elements,'Ti'));
[ytiratioSorted, ix]=sort(ytiratio);
xposition = cumsum([0; (extents(1:end-1,1)+extents(2:end,1))+2]); % centre positions of deconstructed clusters
% load pos
[x,y,z,m,np]=readpos(p);
opos = [x' y' z'];
% load indexed pos
[xc,yc,zc,mc,npc]=readpos(c);
cpos = [xc' yc' zc'];

% use is member to find clustered ions
clusterIds=clusterIndex(x,y,z,xc,yc,zc,mc);
clear xc yc zc x y z

clusters = cell(max(clusterIds),1);
clusterSize = zeros(max(clusterIds),3);
newpos = zeros(sum(clusterIds>0),4); % x y z m
index = 1;
currentX = 0;
for i=1:max(clusterIds)
    % isolate cluster
    clusterm = m(clusterIds==i)'; % get cluster masses
    clusterp = opos(clusterIds==i,:)-repmat(position(i,:),size(clusterm(:,1))); % centred cluster [x y z]
    %clusters{i} = [clusterp-repmat(max(clusterp)-clusterSize(i,:)/2,size(clusterp(:,1))) clusterm];
    newpos(index:(index+length(clusterm)-1),:) = [clusterp+repmat([xposition(ix(i)) 0 0],size(clusterp(:,1))) clusterm];
    index = index + length(clusterm); % increment index counter
    %currentX = currentX + clusterSize(1) + 1; % move next cluster centre + 1nm
end
% save new pos
disp(['Saving deconstructed cluster pos:' regexprep(f,'.indexed.rrng','.decnstrd.pos')]);
savepos(newpos(:,1),newpos(:,2),newpos(:,3),newpos(:,4),regexprep(f,'.indexed.rrng','.decnstrd.pos'));