function [clusterRangeTablesIonic,ionq,clusterRangeTables,clusterRangeCounts,smallList] = clusterDecompTablesIonic(x,y,z,m,clusterIDs,clusterPositions,clusterExtents,rangeTable,rangeElements,overlapY,overlapTable)
%[clusterRangeTablesIonic,ionq,clusterRangeTablesAtomic,clusterRangeCounts,smallList] = clusterDecompTablesIonic(x,y,z,m,clusterIDs,clusterPositions,clusterExtents,rangeTable,rangeElements,overlapY,overlapTable)
% simplified version of the code used in clusterDecomp that only returns
% the rangeTables of the amount of each ion per range.
% ionq is the list of unique ion names. 
% clusterRangeTables are the decomposed atomic range tables per cluster
% clusterRangeCounts the counts in each range of each cluster
% A London Nov 2013

% check inputs
sizeCheck = [size(x);size(y);size(z);size(m);size(clusterIDs)];
if sum(~ismember(sizeCheck,size(x)))
   disp(sizeCheck);
   error('Dimensions of x,y,z,m or clusterIDs are not consistent');
end
% list of ions from rrng file
ions = makeIon(rangeTable(:,3:end),rangeElements);
% add unranged (overlapping) ions to the ions list:
for i = 1:length(overlapTable)
   newIons = ionList(overlapTable(i),rangeElements,1);
   ions = [ions newIons(~ismember(newIons,ions))];
end
[ionq,ia,ic]= unique(ions,'stable'); % get uniquie ions
numOfIons = length(ionq);
% draw up the ionic range table:
%            ion1  ion2  ion3 ion4
%range1        1     0     0   0
%range2       0.6    0    0.4  0 (the result of ion overlap).
rNum = length(rangeTable(:,1));

count = length(clusterExtents);
cubeCounts = zeros(count,length(rangeElements)); % per cluster store decomp'd counts
clusterRangeCounts = zeros(count,length(rangeTable(:,1))); % per cluster per range counts
smallClusterM = cell(count,1);
smallList = zeros(count,1);
overlap_num = length(overlapY); % number of overlaping regions
clusterRangeTables = cell(1,count);
clusterRangeTablesIonic = cell(1,count);
for c = 1:count
    disp(strcat(num2str(c),'/',num2str(count))); % progress bar
    rangeTableDecomp = rangeTable; % rangeTable for this cluster
    rangeTableIonic = full(sparse(1:rNum,ic(1:rNum),ones(rNum,1),rNum,numOfIons));
    mp = m(clusterIDs==c);% selected masses
    % get mass spectrum of this cluster
    [clusterRangeCounts(c,:),cubeCounts(c,:)] = massQuant(mp,rangeTable);
    for o = 1:overlap_num
        % get ionicRangePercentages
        [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
        ionStatus = failedIons;
        % get for errors
        if sum(failedIons)>0
            disp(strcat('Removing ion:',num2str(find(failedIons))));
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
        end
        % detect failure
        if sum(ionicRangeComp(:)) == 0 || sum(isnan(ionicRangeComp(:)))
            % do not change compTable or copy into rangeTable
            % add masses to small cluster M
            smallClusterM{c} = mp';
            smallList(c) = 1;
            % need to do this once per cluster though...
            % we can decompose these small clusters later
            disp(strcat('Cluster:',num2str(c),' added to smallClusterM'));
            rangeTableDecomp = rangeTable; % reset for this cluster
            rangeTableIonic = full(sparse(1:rNum,ic(1:rNum),ones(rNum,1),rNum,numOfIons));
            break
        else
            % find the appropriate ranges
            compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
            %compTable = ionicRangeComp * overlapTable{o};
            %hist(mp,(overlapY{o}(1,1)-1):0.02:(overlapY{o}(end,1)+1));
            %pause
            for t = 1:length(overlapY{o}(:,1))
                tr = overlapY{o}(t,1); % trial range
                yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                if length(yr)>1
                    error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                elseif isempty(yr)
                    %disp(strcat('No range containing ', num2str(tr), ' found'));
                else
                    % copy in the row from the matrix of ionic percentages v elements
                    rangeTableDecomp(yr,3:end) = compTable(t,:);
                    % copy ionicRangeComp columns into rangeTableIonic
                    % ion names in this overlap
                    oions = ionList({overlapTable{o}(logical(~ionStatus'),:)},rangeElements,1);
                    for n = 1:length(oions)
                        % column to copy
                        rangeTableIonic(yr,strcmp(oions(n),ionq)) = ionicRangeComp(t,n);
                    end
                end
            end
        end
    end
    clusterRangeTables{c} = rangeTableDecomp;
    clusterRangeTablesIonic{c} = [rangeTable(:,1:2) rangeTableIonic];
    % display non-integer ionic ranges:
    %disp([rangeTableDecomp(sum(abs(rangeTableIonic-round(rangeTableIonic)),2)~=0,1) rangeTableIonic(sum(abs(rangeTableIonic-round(rangeTableIonic)),2)~=0,:)]);
end
%% Decomp small clusters
if sum(smallList) % are there small clusters?
    disp('Decomp small clusters'); % progress alert
    rangeTableDecomp = rangeTable; % rangeTable for this cluster
    rangeTableIonic = full(sparse(1:rNum,ic(1:rNum),ones(rNum,1),rNum,numOfIons));
    mp = vertcat(smallClusterM{:});
    for o = 1:overlap_num
        % get ionicRangePercentages
        %ionStatus = zeros(length(overlaps),1);
        [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
        ionStatus = failedIons;
        % get for errors
        if sum(failedIons)>0
            disp(strcat('Removing ion:',num2str(find(failedIons))));
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
        end
        % check for failure again?
        compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
        if sum(ionicRangeComp(:)) ~=0
            % find the appropriate ranges
            for t = 1:length(overlapY{o}(:,1))
                tr = overlapY{o}(t,1);
                yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                if length(yr)>1
                    error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                elseif isempty(yr)
                    disp(strcat('No range containing ', num2str(tr), ' found'));
                else
                    % copy in row from compTable
                    rangeTableDecomp(yr,3:end) = compTable(t,:);
                    % ion names in this overlap
                    oions = ionList({overlapTable{o}(logical(~ionStatus'),:)},rangeElements,1);
                    for n = 1:length(oions)
                        % column to copy
                        rangeTableIonic(yr,strcmp(oions(n),ionq)) = ionicRangeComp(t,n);
                    end
                end
            end
        end
    end
    % assign new range tables to each cluster
    clusterRangeTables(logical(smallList)) = {rangeTableDecomp};
    clusterRangeTablesIonic(logical(smallList)) = {[rangeTable(:,1:2) rangeTableIonic]};
end
end