function [clusterRangeTables] = clusterDecompTables(x,y,z,m,clusterPositions,clusterExtents,rangeTable,rangeElements,overlapY,overlapTable,zs)
%[clusterRangeTables] = clusterDecompTables(x,y,z,m,clusterPositions,clusterExtents,rangeTable,rangeElements,overlapY,overlapTable,zs)
% simplified version of the code used in clusterDecomp that only returns
% the rangeTables to do the deconvolution of the ranges into ions.
% A London Nov 2013
count = length(clusterPositions);
cubeCounts = zeros(count,length(rangeElements)); % per cluster store decomp'd counts
cubeRangeCounts = zeros(count,length(rangeTable(:,1))); % per cluster per range counts
smallClusterM = [];
smallList = zeros(count,1);
overlap_num = length(overlapY); % number of overlaping regions
clusterRangeTables = cell(1,count);
for c = 1:count
    disp(strcat(num2str(c),'/',num2str(count))); % progress bar
    rangeTableDecomp = rangeTable; % rangeTable for this cluster
    cx = clusterPositions(c,1); % cluster x,y,z
    cy = clusterPositions(c,2);
    cz = clusterPositions(c,3);
    a = zs*clusterExtents(c); % scaled current cluster radius
    p1 = z>(cz-a);
    p2 = z<(cz+a);
    p3 = x>(cx-a);
    p4 = x<(cx+a);
    p5 = y>(cy-a);
    p6 = y<(cy+a);
    mp = m(p1&p2&p3&p4&p5&p6); % selected masses
    % get mass spectrum of this cluster
    [cubeRangeCounts(c,:),cubeCounts(c,:)] = massQuant(mp,rangeTable);
    for o = 1:overlap_num
        % get ionicRangePercentages
        [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
        ionStatus = failedIons;
        % get for errors
        if sum(failedIons)>0
            disp(strcat('Removing ion:',num2str(find(failedIons))));
            %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
        end
        % detect failure
        if sum(ionicRangeComp(:)) == 0 || sum(isnan(ionicRangeComp(:)))
            % do not change compTable or copy into rangeTable
            % add masses to small cluster M
            smallClusterM = [smallClusterM mp];
            smallList(c) = 1;
            % need to do this once per cluster though...
            % we can decompose these small clusters later
            disp(strcat('Cluster:',num2str(c),' added to smallClusterM'));
            rangeTableDecomp = rangeTable; % reset for this cluster
            break
        else
            % find the appropriate ranges
            compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
            %compTable = ionicRangeComp * overlapTable{o};
            %hist(mp,(overlapY{o}(1,1)-1):0.02:(overlapY{o}(end,1)+1));
            %pause
            for t = 1:length(overlapY{o}(:,1))
                tr = overlapY{o}(t,1);
                yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                if length(yr)>1
                    error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                elseif isempty(yr)
                    %disp(strcat('No range containing ', num2str(tr), ' found'));
                else
                    % copy in the row from the matrix of ionic percentages v elements
                    rangeTableDecomp(yr,3:end) = compTable(t,:);
                end
            end
        end
    end
    clusterRangeTables{c} = rangeTableDecomp;
end
%% Decomp small clusters
if sum(smallList) % are there small clusters?
    disp('Decomp small clusters'); % progress alert
    rangeTableDecomp = rangeTable; % rangeTable for this cluster
    mp = smallClusterM;
    for o = 1:overlap_num
        % get ionicRangePercentages
        %ionStatus = zeros(length(overlaps),1);
        [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
        ionStatus = failedIons;
        % get for errors
        if sum(failedIons)>0
            disp(strcat('Removing ion:',num2str(find(failedIons))));
            %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
        end
        % check for failure again?
        compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
        if sum(ionicRangeComp(:)) ~=0
            % find the appropriate ranges
            for t = 1:length(overlapY{o}(:,1))
                tr = overlapY{o}(t,1);
                yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                if length(yr)>1
                    error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                elseif isempty(yr)
                    disp(strcat('No range containing ', num2str(tr), ' found'));
                else
                    % copy in row from compTable
                    rangeTableDecomp(yr,3:end) = compTable(t,:);
                end
            end
        end
    end
    % assign new range tables to each cluster
    clusterRangeTables(logical(smallList)) = {rangeTableDecomp};
end
end