function [deconvCounts,rangeOutput,extentList,clusterPositions,smallClusters,originalCounts,rangeCounts,rangeTables]=clusterDecomp(rangeFileList,posFileList,clusterFileList,overlaps)
%[deconvCounts,rangeOutput,extentList,clusterPositions,smallClusters,originalCounts,rangeCounts,rangeTables]=clusterDecomp(rangeFileList,posFileList,clusterFileList,overlaps)
% Takes cell arrays of rrng files, posfiles and cluster files as well as a
% definition of the overlapping ions and returns the atomic deconvolved
% counts per cluster (cols are the elements in rangeElements).
% A box of (zs x radius) is used to get the cluster mass spectrum
% Radius here is defined as ExtentZ as given in the clusterFile.csv.
% smallClusters are the lists of clusters that failed the deconvolution and
% so were deconvolted with all the other small clusters.
% originalCounts are the counts as defined in the original range table
% rangeCounts are the ion counts per range
% rangeTables are the ionic range tables (to get decomposition factors on a
% per-cluster basis)
% A London Sept 2013
%% Initialise vars
zs = 1; % The number of rg's to go along XYZ for the cube ROI
posFile = regexprep(posFileList,'.pos',''); % remove .pos
deconvCounts     = cell(length(clusterFileList),1);
originalCounts   = cell(length(clusterFileList),1);
smallClusters    = cell(length(clusterFileList),1);
rangeOutput      = cell(length(clusterFileList),1);
extentList       = cell(length(clusterFileList),1);
clusterPositions = cell(length(clusterFileList),1);
rangeCounts      = cell(length(clusterFileList),1);
rangeTables      = cell(length(clusterFileList),1);
%% Loop through each cluster file in turn
for f=1:length(clusterFileList)
    % Cluster file
    cf = clusterFileList{f};
    %% Read rrng file
    %[element_num, range_num, rangeElements, ranges] = rangeReader(strcat(regexprep(rangeFileList{f},'.rrng',''),'_80.rrng'));
    [element_num, range_num, rangeElements, ranges] = rangeReader(rangeFileList{f});
    rangeOutput{f} = rangeElements;
    % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    
    %% Peak overlap stuff
    % For peak deconvolution
    overlapY = cell(size(overlaps));
    overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data
    
    overlap_num = length(overlaps);
    for o = 1:overlap_num
        overlapY{o} = peakHeights(overlaps{o});
        overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
    end
    %% check for missing ions in overlaps definition
    
    %% Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,clusterPosition,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    clusterPositions{f} = clusterPosition;
    extentList{f} = extentZ;
    %% Read pos file
    [x,y,z,m]=readpos(posFile{f});
    
    %% Initialise vars
    cubeCounts = zeros(count,length(rangeElements)); % per cluster store decomp'd counts
    cubeRangeCounts = zeros(count,length(ranges(:,1))); % per cluster per range counts
    cubeCountsDecomp = cubeCounts;
    smallClusterM = []; % sum of the small clusters' mass spectra
    smallList = zeros(count,1);
    %% loop through all clusters
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count))); % progress bar
        rangeTableDecomp = rangeTable; % rangeTable for this cluster
        cx = clusterPosition(c,1); % cluster x,y,z
        cy = clusterPosition(c,2);
        cz = clusterPosition(c,3);
        a = zs*extentZ(c); % scaled current cluster radius
        p1 = z>(cz-a);
        p2 = z<(cz+a);
        p3 = x>(cx-a);
        p4 = x<(cx+a);
        p5 = y>(cy-a);
        p6 = y<(cy+a);
        mp = m(p1&p2&p3&p4&p5&p6); % selected masses
        % get mass spectrum of this cluster
        [cubeRangeCounts(c,:),cubeCounts(c,:)] = massQuant(mp,rangeTable);
        for o = 1:overlap_num
            % get ionicRangePercentages
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
            ionStatus = failedIons;
            % get for errors
            if sum(failedIons)>0
                disp(strcat('Removing ion:',num2str(find(failedIons))));
                %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
                [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
            end          
            % detect failure
            if sum(ionicRangeComp(:)) == 0 || sum(isnan(ionicRangeComp(:)))
                % do not change compTable or copy into rangeTable
                % add masses to small cluster M
                smallClusterM = [smallClusterM mp];
                smallList(c) = 1;
                % need to do this once per cluster though...
                % we can decompose these small clusters later
                disp(strcat('Cluster:',num2str(c),' added to smallClusterM'));
                rangeTableDecomp = rangeTable; % reset for this cluster
                break
            else
                % find the appropriate ranges
                compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
                %compTable = ionicRangeComp * overlapTable{o};
                %hist(mp,(overlapY{o}(1,1)-1):0.02:(overlapY{o}(end,1)+1));
                %pause
                for t = 1:length(overlapY{o}(:,1))
                    tr = overlapY{o}(t,1);
                    yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                    if length(yr)>1
                        error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                    elseif isempty(yr)
                        %disp(strcat('No range containing ', num2str(tr), ' found'));
                    else
                        % copy in the row from the matrix of ionic percentages v elements
                        rangeTableDecomp(yr,3:end) = compTable(t,:);
                        
                    end
                end
            end
            %disp(rangeElements');
            %disp(rangeTableDecomp-rangeTable);
            %pause
        end
        % ready to do the new decomp
        if ~smallList(c)
            cubeCountsDecomp(c,:) = cubeRangeCounts(c,:)*(rangeTableDecomp(:,3:end));
            rangeTables{f}{c}     = rangeTableDecomp;
        end
    end
    %% Decomp small clusters
    if sum(smallList) % are there small clusters?
        disp('Decomp small clusters'); % progress alert
        rangeTableDecomp = rangeTable; % rangeTable for this cluster
        mp = smallClusterM;
        for o = 1:overlap_num
            % get ionicRangePercentages
            %ionStatus = zeros(length(overlaps),1);
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
            ionStatus = failedIons;
            % get for errors
            if sum(failedIons)>0
                disp(strcat('Removing ion:',num2str(find(failedIons))));
                %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
                [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
            end
            % check for failure again?
            compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
            if sum(ionicRangeComp(:)) ~=0
            % find the appropriate ranges
            for t = 1:length(overlapY{o}(:,1))
                tr = overlapY{o}(t,1);
                yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
                if length(yr)>1
                    error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
                elseif isempty(yr)
                    disp(strcat('No range containing ', num2str(tr), ' found'));
                else
                    % copy in row from compTable
                    rangeTableDecomp(yr,3:end) = compTable(t,:);
                end
            end
            end
        end
        % decompose each small cluster
        for c = 1:count
            if smallList(c)
                % small cluster found
                cubeCountsDecomp(c,:) = cubeRangeCounts(c,:)*(rangeTableDecomp(:,3:end));
                rangeTables{f}{c}     = rangeTableDecomp;
            end
        end
    end
    
    rangeCounts{f}      = cubeRangeCounts;
    originalCounts{f}   = cubeCounts;
    deconvCounts{f}     = cubeCountsDecomp;
    smallClusters{f}    = smallList;
end
end