function [elements,countsDecomp,counts,position,ionType,radii,nTable,dmax,dbulk,derode,nmin,core,count] = clusterDataReaderDetails(clusterDataFile)
% [elements,countsDecomp,counts,position,ionType,rg,nTable,dmax,dbulk,...
% derode,nmin,core,count] = clusterDataReaderDetails(clusterDataFile)
% countsDecomp = decomposed elemental counts per cluster
% counts = ion counts per cluster (ions defined in ionType cell)
% count = total number of clusters
% core = core ion used in dmax
% nTable = solute ions per cluster
% This is to read cluster data exported from IVAS and return the details of
% the clusters and the dmax settings that were used
% If you have run this function before then it can use ionsData.xls if it
% is in the same directory
% A London 2013
% Updated 2014 to use only clusterExtent.m function
[elements,countsDecomp,counts,position,ionType,radii,~,~,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterDataFile);
end