function totTime = clusterDataReader(clusterDataFile)
% This is to read cluster data exported from IVAS and return .xls file
% Usage: clusterDataReader(clusterDataFile.csv)
% If you have run this function before then it can use ionsData.xls if it
% is in the same directory
% A London 2012

startTime = cputime; % start the clock!
% starting column header name (eg FeCount) for count data
% Need to import the csv and read the number of counts for each ion
%startingCol = 'FeCount'; % no space OLD

%check for cached ionsData file
if(exist('ionsData.xls','file'))
    % read ionsData.xls file if present:
    % read data file
    [num_e,elements]=xlsread('ionsData.xls',1,'1:1'); % was 'A:A'
    disp('Read ionsData.xls');
    elements = transpose(elements);
    % read the rest of the file
    [num,txt,all]=xlsread('ionsData.xls');
    ions = all(2:end,:); % crop the data ignoring first row
    % free memory
    clear('num', 'txt', 'all');
else
    % generate a new ionsData.xls file
    disp('Did not find ionsData.xls... making a new one');
    ionsFile = ionsDataMaka(['Fe';'Cr';'Y ';'Ti';'O ';'C ';'N ';'Si';'Ar';'Mn';'W ';'Ga']);
    disp(strcat('Made new ionsData.xls file:',ionsFile));
end
% read cluster data file (should be defined in input params)
%clusterDataFile = 'R14_15065-v04_Y_YO_09_10.csv';

fid = fopen(clusterDataFile);
tline = fgets(fid);
while ~feof(fid)
    tline = fgets(fid);
    S = sscanf(tline,'%s');
    clusterCount = sscanf(S,'Cluster%d'); % cluster ID
    %disp(sscanf(S,'Cluster%d'));
    if(strfind(S,'Count')>0)
        data_ionCount = length(strfind(S,'Count'));
    end
end
fclose(fid);

% display clusters found
disp(strcat(num2str(clusterCount),' clusters found'));
clusters = clusterCount;
% final data will be put here
clusterData = zeros(clusterCount,data_ionCount);
radii = zeros(clusterCount,1);

%{
                       < .. Ion complex .. >
cluster ID (up/down)    Cluster counts here
%}
disp(strcat('Reading:',clusterDataFile));
fid = fopen(clusterDataFile);
tline = fgets(fid);
headerFlag = 0;
while ~feof(fid)
    tline = fgets(fid);
    %disp(tline); % debug to get file
    S = sscanf(tline,'%s');
    if(strfind(S,'Count')>9) % if position of 'Count' > 9
        % this is the title line with all the names in, all lines
        % below contain cluster data
        % number of ions
        data_ionCount = length(strfind(S,'Count'));
        % need to store the data: column, elemental count
        column_data = num2cell(zeros(data_ionCount,num_e+1));
        column_number = zeros(data_ionCount,1); % this is  the ',' number in the csv file
        % we have found the counts line
        % extract elements and column positions
        thingy = S; % debugging
        % extract columns
        columns = regexp(S,'[^,]*','match','ignorecase');
        %disp(columns) % debug
        % Cycle through all 'ions'+'Count'
        % this will find the starting column
        potentialStart = zeros(length(ions),1);
        for i = 1:length(ions)
            found = find(ismember(columns, strcat(ions(i,1),'Count'))==1);
            if(numel(found)==0)
                potentialStart(i) = NaN;
            else
                potentialStart(i) = found(1);
            end
        end
        % check we have look at all the ions:
        disp(strcat('Found:',num2str(sum(potentialStart>0)),' ions'));
        % now we have all the ions (hopefully)
        % take the min find the first one
        startingCol = min(potentialStart);
        %fePosition =  find(ismember(columns, startingCol)==1); %OLD
        %data_ions = regexp(thingy,',*Count','split','ignorecase');
        % this contains , so remove them
        %data_ions = strrep(data_ions,',','');
        row = 1; % the current row of the column_data
        % Note FeCount is after the (startingCol)th  ','
        %lets count commas
        comma=0;
        comma_array = zeros(length(strfind(S,',')),2);
        %{
        Comma Array
        1 1
        2 9
        3 27
        4 40
        ... etc
        comma no and index
        %}
        for i=1:length(S);
            if(strcmp(',',S(i)));
                comma=comma+1;
                comma_array(i,1) = comma;
                comma_array(i,2) = i;
            end;
        end
        for m = startingCol:length(columns)
            for n = 1:length(ions)
                % scan all ions (n) and all columns (m)
                if(strcmp(columns{m},strcat(ions{n,1},'Count'))) % found match
                    column_data(row,:) = ions(n,:); % copies a line from ions
                    % ',' position at:
                    findRes = strfind(S,strcat(ions{n},'Count'));
                    %disp(strcat('Found',ions{n},'Count')); % debug
                    findResLength = size(findRes,2); % length of search results
                    if(findResLength == 1) % found only one result
                        column_number(row,1) = comma_array(findRes(1,1)-1,1);
                        %disp(strfind(S,strcat(ions{n},'Count'))-1);
                        row = row + 1;
                    else
                        %loop through search results
                        for p=1:(findResLength)
                            if(thingy(findRes(1,p)-1)==',') % this is because a search for 'OCount' returns the correct column as well as Fe'OCount' etc
                                column_number(row,1) = comma_array(findRes(1,p)-1,1);
                                %disp(strfind(S,strcat(ions{n},'Count'))-1);
                                row = row + 1;
                            end
                        end
                    end
                end
            end
        end
        headerFlag = 1;
    end
    if headerFlag == 1
        % this is still headers
        headerFlag = 2;
    elseif headerFlag == 2
        % this is the matrix
        headerFlag = 3;
    elseif headerFlag == 3
        % this is cluster data
        clusterID = sscanf(S,'Cluster%d');
        %disp(clusterID); % debug
        % count commas
        comma = 1;
        for i=1:length(S);
            if(strcmp(',',S(i)));
                comma=comma+1; % found comma
                % for col = 1:1%data_ionCount
                %if comma == 
                %disp(comma);
                if comma == 9
                    radii_s = sscanf(S((i+1):end),'%f,%f,%f');
                    radii(clusterID) = sqrt(radii_s(1)*radii_s(1)+radii_s(2)*radii_s(2)+radii_s(3)*radii_s(3));
                elseif comma == column_number(1)
                    %disp(S((i+2):(length(S)))); % debug
                    %disp(sscanf(S((i+1):(length(S))),',%d')); % debug
                    clusterData(clusterID,:) = sscanf(S((i+1):(length(S))),',%d');
                    %disp(row);
                    %row = row + 1;
                end
                % end
            end
        end
    end
    
end
fclose(fid);

% now we have clusterData! Time to decompose those counts
% decomposed counts
clusterDataDe = zeros(clusterCount,num_e); % initialise variable
mym = cell2mat(column_data(:,2:size(column_data,2))); % crop and convert column_data (remove labels)
% multiply!
%disp(mym); % debug
%disp(clusterData); % debug
clusterDataDe = clusterData*mym; % result :)
%clusterDataLa(1,:) = elements;
% write output (optional)
output_file = strcat(strrep(clusterDataFile,'.csv',''),'_decomp.xls');
xlswrite(output_file,transpose(elements),1,'A1');
xlswrite(output_file,clusterDataDe,1,'A2');

% cluster comp
% include which elements?
include = {3,4,5};
outPut = cell(clusterCount,length(include)+1);

for i = 1:length(include)
    outPut(1,i) = elements(include{i});
end
outPut{1,length(include)+3} = 'rg';
outPut{1,length(include)+1} = 'x';
outPut{1,length(include)+2} = 'y';

for cluster = 1:clusterCount
    tot = 0;
    for i = 1:length(include)
        %disp(clusterDataDe((cluster),include{i}));
        tot = tot + clusterDataDe((cluster),include{i});
    end
    for i = 1:length(include)
        % write column
        outPut{cluster+1,i} = clusterDataDe(cluster,include{i})/tot;
    end
    outPut{cluster+1,length(include)+3} = radii(cluster);
    outPut{cluster+1,length(include)+1} = outPut{cluster+1,length(include)-2}+outPut{cluster+1,length(include)}/2;
    outPut{cluster+1,length(include)+2} = outPut{cluster+1,length(include)}*sqrt(3)/2;
end

%write to excel
disp(strcat('Writing file:',output_file));
xlswrite(output_file,outPut,1,strcat(char(64+num_e+1),'1'));
totTime = cputime-startTime;
end