% after running clusterMassSpec2 this script takes each of the decomposed
% counts and turns them into data that can be plotted on a ternary diagram.
% It also gets the rangeElements (needed to identify the columns of
% clusterDecomposedData = cubeCounts3) and reads the cluster files to get the Z-extent
% for sizing the clusters.
%% Input files, these could be lists
if(0) % unirradiated data
    for i = 1:1
rangeList = {'15868','15867','15734','15065','15733','15783'};
versionList = {1,2,2,4,1,2}; % version of recon to use
folderList = {' Cr02',' Cr01',' Cr02',' FeYTi_ex',' YTi04',' YTi04'}; % additional post folder name guff
%matList = {'Fe-14Cr ODS','Fe-14Cr ODS','Fe-14Cr ODS','Fe ODS','Fe ODS','Fe ODS'};
[rangeFileList, posFileList] = rpvLs(rangeList,versionList,folderList);
clusterFile = {'R14_15868-v01_YYOTiO_80.csv',...
    'R14_15867-v02_YYOTiO_80.csv',...
    'R14_15734-v02_YYOTiOO_80_08.csv',...
    'R14_15065-v04_YYOTiOO_08_80.csv',...
    'R14_15733-v01_YYOTiO_80.csv',...
    'R14_15783-v02_Y_YO_10_06.csv'};
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
    end
end
if(0)
% irradiated samples
rangeList = {'17014', '17031', '17038', '17053', '17343', '17344', '16977', '17167', '17169', '17226', '16559', '16915', '16917', '16933', '17156', '17157', '17183', '17183', '16421', '16469', '16725', '16731', '16919'};
versionList = {1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1}; % version of recon to use
folderList = {'', '', '', '', '', '', '', '', '', '', ' C1', '', '', '', '', '', '', '', ' C2', ' C2', '', '', ''}; % additional post folder name guff
[rangeFileList, posFileList] = rpvLs(rangeList,versionList,folderList);
clusterFile = dataFiles(:,2);
clusterRoot = 'C:\Users\Andy\APT\clusterAnalysis\';
end
% B2 unirradiated liftout
rangeList = {'17868','17870','17886','17890'};
versionList = {1,1,1,2};
folderList = {'','','',''};
clusterFile = {'R14_17868-v01_OYYOTiO.csv', 'R14_17870-v01_OYYOTiO.csv','R14_17886-v01-clip2_OYYOTiOTiO2.csv','R14_17890-v02_YOFeO.csv'};
[rangeFileList, posFileList] = rpvLs(rangeList,versionList,folderList);
irrdList = {0,0,0,0};
matList = {'Fe ODS','Fe ODS','Fe ODS','Fe ODS'};

sizeList = cell(length(clusterFile),1);
terList = cell(length(clusterFile),1);
totalClusters = 0;
%% per cluster ops
for f=1:length(clusterFile)
    cf = strcat(clusterRoot,clusterFile{f});
    [element_num, range_num, rangeElements, ranges] = rangeReader(strcat(regexprep(rangeFileList{f},'.rrng',''),'_80.rrng'));
    % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    totalClusters = totalClusters + count;
    sizeList{f} = extentZ;
    %% turn counts into ternary plotting data:
    cubeCounts2 = cubeCounts3{f};
    terXY2 = [];
    terplot(6);
    hold on
    title('Decomposed Composition');
    t = sum(cubeCounts2(:,[find(strcmp(rangeElements,'Y')) find(strcmp(rangeElements,'Ti')) find(strcmp(rangeElements,'O'))]),2);
    terXY2(:,1) = cubeCounts2(:,strcmp(rangeElements,'Y'))./t + 0.5*cubeCounts2(:,strcmp(rangeElements,'Ti'))./t;
    terXY2(:,2) = 0.866*cubeCounts2(:,strcmp(rangeElements,'Ti'))./t;
    scatter(terXY2(:,1),terXY2(:,2),(radii*2).^2,clusterColour(cubeCounts2(:,[find(strcmp(rangeElements,'Y')) find(strcmp(rangeElements,'O')) find(strcmp(rangeElements,'Ti'))])),'filled'); % new data
    spacing = 0.05;
    text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
    text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
    text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');
    hold off
    terList{f} = terXY2;
end
%% compile export data
exportData = cell(totalClusters,6);
i = 1;
for f=1:length(clusterFile)
    ii = i+length(terList{f}(:,1))-1;
    exportData(i:ii,1) = matList(f); % mat factor
    exportData(i:ii,2) = num2cell(terList{f}(:,1)); % x
    exportData(i:ii,3) = num2cell(terList{f}(:,2)); % y
    exportData(i:ii,4) = num2cell(sizeList{f}); % radius
    exportData(i:ii,5) = irrdList(f); % irrdTemp
    exportData(i:ii,6) = rangeList(f); % run number
    i = i + length(terList{f}(:,1));
end