% Get atomic cluster composition from IVAS cluster files
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles({'Unirrd'});
numFiles = length(matList);
te = {'Y','O','Ti'}; % target elements to count
result = cell(1,3); % run, counts, size
index = 1; % row index for results table
for f = 1:numFiles
    [elements,countsDecomp,counts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterFileList{f});
    % order the elements
    p = zeros(1,length(te));
    for i=1:length(te)
        s = find(strcmp(te{i},elements));
        if isempty(s)
            error(strcat('Element:',te{i},' not found'));
        else
            p(i) = s;
        end
    end
    % return the comp per file
    [~,r,~]=fileparts(rangeFileList{f});
    result(index:(index+count-1),1) = {r}; % range number
    result(index:(index+count-1),2) = num2cell(sum(countsDecomp(:,p),2));
    result(index:(index+count-1),end) = num2cell(extentZ);
    index = index + count;
end