% even more simple cluster mass-spectra peak deconvolution
% based on code inclusterMassSpec3 using clusterDecomp function
% A. London Jan 2014

%% Input files, these can be lists
opts = {'Unirrd'};
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);
posRoot = 'C:\Users\Andy\APT\';

% remove extension and add cluster suffux
posFile = regexprep(posFileList,'.pos','.cluster');

%% For peak deconvolution
% Split into two because there are two types of overlap that can occur
cl = strcmp(matList,'Fe-14Cr ODS');
irrdList(strcmp(matList,'Fe-14Cr ODS')|strcmp(matList,'Fe ODS'))={'0'};
% Cr-containing
overlaps = cell(1,3);
overlaps{1} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'} {3,'Y','O'}};
overlaps{2} = {{2,'Fe'} {2,'Cr'}};
overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
[counts(cl),elements(cl),extentZ(cl),positions(cl),smallList(cl)] = clusterDecomp(rangeFileList(cl),posFileList(cl),clusterFileList(cl),overlaps);

% Cr-free section
overlaps = cell(1,2);
overlaps{1} = {{2,'Ti','O'} {1,'O',2}};
overlaps{2} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
[counts(~cl),elements(~cl),extentZ(~cl),positions(~cl),smallList(~cl)] = clusterDecomp(rangeFileList(~cl),posFileList(~cl),clusterFileList(~cl),overlaps);
%% more setup
sizeList = cell(length(clusterFileList),1);
terList = cell(length(clusterFileList),1);
rangeList = cell(length(clusterFileList),1);
countList = cell(length(clusterFileList),1);
totalClusters = 0;

%% clusterPosPlot
for i = 1:length(clusterFileList)
    [~, rangeList{i}, ~] = fileparts(rangeFileList{i});
    y = counts{i}(:,strcmp(elements{i},'Y'));
    ti = counts{i}(:,strcmp(elements{i},'Ti'));
    o = counts{i}(:,strcmp(elements{i},'O'));
    t = y+ti+o;
    terList{i} = [(y./t+ti./(2*t)) sqrt(3/4)*ti./t];
    [~,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,sizeList{i},nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterFileList{i});
    totalClusters = totalClusters + count;
    countList{i} = num2cell(t);
end

% takes each of the decomposed
% counts and turns them into data that can be plotted on a ternary diagram.
% It also gets the rangeElements (needed to identify the columns of
% clusterDecomposedData = cubeCounts3) and reads the cluster files to get the Z-extent
% for sizing the clusters.
%% compile export data
exportData = cell(totalClusters,7);
exportData(1,:) = {'mat','x','y','r','irrdTemp','run','count','small'};
i = 2;
for f=1:length(clusterFileList)
    ii = i+length(terList{f}(:,1))-1;
    exportData(i:ii,1) = matList(f); % mat factor
    exportData(i:ii,2) = num2cell(terList{f}(:,1)); % x
    exportData(i:ii,3) = num2cell(terList{f}(:,2)); % y
    exportData(i:ii,4) = num2cell(sizeList{f}); % radius
    exportData(i:ii,5) = irrdList(f); % irrdTemp
    exportData(i:ii,6) = rangeList(f); % run number
    exportData(i:ii,7) = countList{f}; % cluster solute (Y,Ti,O) counts
    exportData(i:ii,8) = smallList{f}; % cluster solute (Y,Ti,O) counts
    i = i + length(terList{f}(:,1));
end
% save file
cell2csv('ternData2014.csv',strCellConvert(exportData));