%clusterCompAndProfileDecompIonic
% Using cluster files (csv from IVAS), pos & range files, return a
% cluster-sensitive deconvolved ionic line profile
% Deconvolve peak overlaps on a cluster-by-cluster basis
% Use the deconvolved range table to calculate the ionic cluster profile
% Optionally decompose ionic counts into elemental ones
% zprofileCache columns:
% 1 zprofile cell(count){profilePoints-by-ions} 1 nm square, columns are ions in ionq
% 2 rangeElements {cell} of elements (str)
% 3 extentZ [double list]
% 5 ionq; % {cell} list of ions (str format) in the profile
% per-cluster decomposed data
% 4 clusterRangeTableIonic, cell(count){ranges-by-ions (in ionq)}, ionic range table
% 6 clusterRangeTablesAtomic, cell(count){ranges-by-elements (in rangeElements)}, atomic range table
% 7 clusterDecomposedCounts; % atomic composition
% 8 zprofileR cell(count){profilePoints-by-ions} rg square, columns are ions in ionq
% 9 smallList 0/1 % clusters that failed fitting
% A London Jan 2015 
load('clusterDecompData2015e.mat'); % load original data
startDiary('-clusterDecompIonicNewOverlaps');
disp('Only running for data sets:');
%selectedData = [8,27,29,30,34,39,41,46,50,52,96,97,99,100,101,104,108];
selectedData = [79];
%selectedData = [97,99];
for i=selectedData
    disp(d(i,1));
end
%% Input files, these can be lists
zs = 2.5; % N times extent = cluster mass spectrum sampled volume
profilePoints = 100;
[d,cols]=dataBase('run>0',1);
posRoot = 'C:\Users\Andy\APT\';
rrngFileList=strcat(posRoot,'ranges\',regexprep(d(:,strcmp(cols,'rrng')),'\.rrng','ss_80.rrng','ignorecase'));
posFileList=strcat(d(:,strcmp(cols,'reconRoot')),d(:,strcmp(cols,'pos')));
clusterFileList = strcat(posRoot,'clusterAnalysis\',d(:,strcmp(cols,'cf')));
indexedPosList = regexprep(d(:,strcmp(cols,'clrIdxRrng')),'\.rrng','.pos');
overlapsList = d(:,strcmp(cols,'overlaps'));
clusterDecompLineprofilesName = strcat(datestr(now,30),'_clusterDecomp.mat');
% storing the data
%zprofileCache = cell(length(rrngFileList),9);
%% Load each pos file in turn:
for f=selectedData
    %% decide which ions are overlapping
    overlaps = overlapsList{f}';
    %% Reading data files
    % Cluster file
    cf = clusterFileList{f};
    
    % Read rrng file
    [element_num, range_num, rangeElements, ranges] = rangeReader(rrngFileList{f});
    
    % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    
    % for the mass list counting:
    rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
    %% Peak overlap stuff
    % For peak deconvolution
    overlapY = cell(size(overlaps));
    overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data
    
    overlap_num = length(overlaps);
    for o = 1:overlap_num
        overlapY{o} = peakHeights(overlaps{o});
        overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
    end
    %% Load pos data
    % Read pos file
    [x,y,z,m,nb]=readpos(posFileList{f});
    [xc,yc,zc,mc]=readpos(indexedPosList{f});
    if nb<20000000
        try
            clusterIds=clusterIndex(x,y,z,xc,yc,zc,mc);
        catch % if fails due to too little memory
            clusterIds=clusterIndexPart(x,y,z,xc,yc,zc,mc);
        end
    else
        clusterIds=clusterIndexPart(x,y,z,xc,yc,zc,mc);
    end
    clear xc yc zc mc
    %% Get deconvolved range tables for each cluster:
    [clusterRangeTableIonic,ionq,clusterRangeTablesAtomic,clusterRangeCounts,smallList] = clusterDecompTablesIonic(x,y,z,m,clusterIds,position,extentZ,rangeTable,rangeElements,overlapY,overlapTable);
    clear('clusterIds');
    % calculate the decomposed cluster compostions
    clusterDecomposedCounts = zeros(count,length(rangeElements));
    for c=1:count
        clusterDecomposedCounts(c,:) = clusterRangeCounts(c,:)*clusterRangeTablesAtomic{c}(:,3:end);
    end
    %% Initialise vars
    zprofile = cell(count,1); % per cluster store a cell of counts and positions
    zprofileR = cell(count,1); % per cluster store a cell of counts and positions
    %% loop through all clusters of this {f} analysis and make *profile*
    for c = 1:count
        disp(strcat(num2str(c),'/',num2str(count))); % progress bar
        cx = position(c,1); % cluster x,y,z
        cy = position(c,2);
        cz = position(c,3);
        % fixed to 1 nm
        cr = 1; 
        p = x>(cx-cr) & x<(cx+cr);
        p = p & y>(cy-cr) & y<(cy+cr);
        cr = extentZ(c); % current cluster Z-extent
        p = p & z>(cz-zs*cr) & z<(cz+zs*cr); % longer than the cluster
        zprofile{c} = clusterProfileEleNP(z(p),m(p),clusterRangeTableIonic{c},profilePoints);
        cr = radii(c); % current cluster radius gyration
        p = x>(cx-cr) & x<(cx+cr);
        p = p & y>(cy-cr) & y<(cy+cr);
        cr = extentZ(c); % current cluster radius
        p = p & z>(cz-zs*cr) & z<(cz+zs*cr); % longer than the cluster
        zprofileR{c} = clusterProfileEleNP(z(p),m(p),clusterRangeTableIonic{c},profilePoints);
    end
    %% Save data
    clear x y z m p nb
    zprofileCache{f,1} = zprofile; % 1 nm square, columns are ions in ionq
    zprofileCache{f,2} = rangeElements;
    zprofileCache{f,3} = extentZ;
    zprofileCache{f,5} = ionq; % list of ions in the profile
    % per-cluster decomposed data
    zprofileCache{f,4} = clusterRangeTableIonic;  % ionic range table
    zprofileCache{f,6} = clusterRangeTablesAtomic;% atomic range table
    zprofileCache{f,7} = clusterDecomposedCounts; % atomic composition
    zprofileCache{f,8} = zprofileR; % rg square, columns are ions in ionq
    zprofileCache{f,9} = smallList; % clusters that failed fitting
    zprofileCache{f,10} = clusterRangeCounts; % counts per range
    % save the current desktop incase of issues
    %save(clusterDecompLineprofilesName,'zprofileCache');
end
%save('clusterDecompData2015f.mat')
%zprofileCacheSummary
diary off