function [atomicCounts,elementsOut,extentList,clusterPositions]=clusterComp2(clusterFileList,elements)
%[atomicCounts,elements,extentList,clusterPositions]=clusterComp2(clusterFileList,{elements})
% Get decomposed atomic counts per cluster from an IVAS csv cluster file
% The elements arg is optional, if you provide an elements definition then
% it will only return the counts of these elements in that order. If it
% cannot find an element in the range-file then the counts will be set to
% zero.
% Reads CSV file using clusterExtent.m
numFiles = length(clusterFileList);
atomicCounts = cell(1,numFiles);
extentList = cell(1,numFiles);
clusterPositions = cell(1,numFiles);
elementsOut = cell(1,numFiles);
for f = 1:numFiles
    [rangeElements,countsDecomp,~,clusterPositions{f},~,~,~,extentList{f}] = clusterExtent(clusterFileList{f});
    if exist('elements','var')
        te = elements;
        p = zeros(1,length(te)); % order the elements
        for i=1:length(te)
            s = find(strcmp(te{i},rangeElements));
            if isempty(s)
                disp(strcat('Element:',te{i},' not found'));
                % add element to counts
                p(i) = length(te)+1;
                % set the counts of this new element to zero
                countsDecomp = padarray(countsDecomp,[0 1],'post');
            else
                p(i) = s;
            end
        end
        atomicCounts{f} = countsDecomp(:,p);
        elementsOut{f} = te;
    else
        atomicCounts{f} = countsDecomp;
        elementsOut{f} = rangeElements;
    end
end