% Get atomic cluster composition from IVAS cluster files
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles({'Yex'});
numFiles = length(matList);
te = {'Fe','Y','O'}; % target elements
result = cell(1,(1+length(te)+1)); % run, comp, size
index = 1; % row index for results table
for f = 1:numFiles
    [elements,countsDecomp,counts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterFileList{f});
    % check that these have the O2 ion in them (all hard coded)
    if ~sum(strcmp(ionType,'O2'))
        if ~strcmp(ionType,'none')
            error(rangeFileList{f});
        end
    end
    % order the elements
    p = zeros(1,length(te));
    for i=1:length(te)
        s = find(strcmp(te{i},elements));
        if isempty(s)
            error(strcat('Element:',te{i},' not found'));
        else
            p(i) = s;
        end
    end
    % return the comp per file
    [~,r,~]=fileparts(rangeFileList{f});
    result(index:(index+count-1),1) = {r}; % range number
    result(index:(index+count-1),2:(1+length(te))) = num2cell(countsDecomp(:,p));
    result(index:(index+count-1),end) = num2cell(extentZ);
    index = index + count;
end