function rgbMatrix = clusterColour(comp)
% rgbMatrix = clusterColour(comp)
% comp is a n-by-3 matrix of counts of each element to be a different
% colour. comp(:,1) will be blue, 2 red and 3 green (just to be consistent
% with Y,O,Ti being blue, red, green.

% Column 2 of comp will be red, 3 will be green etc...
rgbOrder = [2 3 1]; % this could be an agg-input to the function
% re-order to make calcs simpler:
comp = comp(:,rgbOrder);
rgbMatrix = comp./[sum(comp,2) sum(comp,2) sum(comp,2)];


minMat = min(rgbMatrix,[],1);
maxMat = 1./(max(rgbMatrix,[],1)-minMat);
if(0)
    % Scale each component between 0 and 1
    % scale to get max contrast
    for i = 1:length(comp(:,1))
        rgbMatrix(i,:) = (rgbMatrix(i,:)-minMat).*maxMat;
    end
elseif(0)
    % Scale the whole data uniformly
    % TODO
    
elseif(1)
    % Scale globaly to known positions:
    % Red 1-0: conc from 0.8 to 0.4
    % Green 1-0: conc from 0.4 to 0
    % Blue 1-0: conc from 0.6 to 0
    % These should work ok with my cluster compositions
    
    % make the data outside the range just the max colour scale
    rgbMatrix = [min(max(rgbMatrix(:,1),0.5),0.7) min(rgbMatrix(:,2),0.4) min(rgbMatrix(:,3),0.6)];
    % now scale it
    rgbMatrix = [(1/.2)*(rgbMatrix(:,1)-.5) (1/.4)*rgbMatrix(:,2) (1/.6)*rgbMatrix(:,3)];
end
end