%Checks the overlaps per run against the range file to see if there are any
%missing ions - use this before using clusterCompAndProfileDecompIonic.m
% A London Jan 2015 

%% Input files, these can be lists
zs = 2; % N times extent = cluster mass spectrum sampled volume
profilePoints = 100;
[d,cols]=dataBase('run>0',1);
posRoot = 'C:\Users\Andy\APT\';
rrngFileList=strcat(posRoot,'ranges\',regexprep(d(:,strcmp(cols,'rrng')),'\.rrng','ss_80.rrng','ignorecase'));
posFileList=strcat(d(:,strcmp(cols,'reconRoot')),d(:,strcmp(cols,'pos')));
clusterFileList = strcat(posRoot,'clusterAnalysis\',d(:,strcmp(cols,'cf')));
indexedPosList = regexprep(d(:,strcmp(cols,'clrIdxRrng')),'\.rrng','.pos');
overlapsList = d(:,strcmp(cols,'overlaps'));
% remove extension:
posFile = regexprep(posFileList,'.pos','');

% storing the data
zprofileCache = cell(length(rrngFileList),6);
%% Load each pos file in turn:
for f=38:length(rrngFileList)
    %% decide which ions are overlapping
    overlaps = overlapsList{f}';
    %% Reading data files
    % Cluster file
    cf = clusterFileList{f};

    % Read cluster data file for all it's worth!
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    

    %% Peak overlap stuff
    % For peak deconvolution
    overlapY = cell(size(overlaps));
    overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data
    
    overlap_num = length(overlaps);
    for o = 1:overlap_num
        addOverlapIonsToRangeFile(overlaps{o},rrngFileList{f});
        % Read rrng file
        [element_num, range_num, rangeElements, ranges] = rangeReader(rrngFileList{f});
        overlapY{o} = peakHeights(overlaps{o});
        overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
    end
end