% script for plotting from cluster count distributions generated by IVAS
% see 10.1016/j.ultramic.2012.12.011 for details
fileRoot = 'C:\users\andy\APT\clusterAnalysis\';
% get file names
names = dir(strcat(fileRoot,'R14_18420*CCD*.csv'));
names = {names.name}';
nmin=cell(length(names),1);
for i = 1:length(names)
    % read files
    [dmaxnm,Count,RandomizedCount,nmin{i}] = importCCDfile(strcat(fileRoot,names{i}));
    x = dmaxnm;
    y(:,i) = (Count-RandomizedCount)./Count;
end

plot(x,y);
ylim([0.9 1]);
xlabel('d_{max} nm');ylabel('(N_{real}-N_{rand})/N_{real}');
legend(cellfun(@(x) sprintf('%d',x),nmin,'uni',false));