function cell2csvParts(filename,headers,cellArray1,matrix1,delimiter)
% Writes cell array content into a *.csv file. Headers as the first line
% and the arrays like so: [cellArray1 matrix1]
% 
% CELL2CSV(filename,cellArray,delimiter)
%
% filename      = Name of the file to save. [ i.e. 'text.csv' ]
% cellarray    = Name of the Cell Array where the data is in
% delimiter = seperating sign, normally:',' (default)
%
% by Sylvain Fiedler, KA, 2004
% modified by Rob Kohr, Rutgers, 2005 - changed to english and fixed delimiter
% modified by A London, 2014, added '%s', to fprintf(datei,var);
if nargin<5
    delimiter = ',';
end
datei = fopen(filename,'w');
if datei<0
    error(['Failed to open file:' filename]);
end
if length(headers) ~= (size(cellArray1,2)+size(matrix1,2))
   error('Header not correct length');
end
if size(cellArray1,1)~=size(matrix1,1)
   error('Lengths of cell array and matrix don''t match'); 
end
% convert cell array to strings
tic;p=cell2mat(cellfun(@isnumeric,cellArray1,'uni',0));toc
tic;cellArray1(p) = cellfun(@(x) sprintf('%0.5g',x),cellArray1(p),'uni',0);toc
clear p
tic;cellArray1 = strcat(cellArray1,delimiter);toc

% headers
for s=1:length(headers)
    var = headers{s};
    
    if size(var,1) == 0
        var = '';
    end
    
    if isnumeric(var) == 1
        var = num2str(var);
    end
    
    fprintf(datei,'%s',var);
    if s ~= size(headers,2)
        fprintf(datei,[delimiter]);
    else
        fprintf(datei,'\n');
    end
end
% body
for z=1:size(cellArray1,1)
    var = horzcat(cellArray1{z,:});
    fprintf(datei,'%s',var);
    t=[sprintf(['%f' delimiter],matrix1(z,1:end-1)) sprintf('%f',matrix1(z,end))];
    fprintf(datei,'%s\n',t);
end
fclose(datei);
disp(['Wrote:' filename]);