function [x,y]=binXY(x,y,binby)
%[x,y]=binXY(x,y,binby)
% bin y counts by a factor 'binby', eg 2 would reduce the length of y and x
% by 2.

% binning
q=1;p=binby;

M=[x y]; % only two columns
[m,n]=size(M); %M is the original matrix

% crop data so that it will bin nicely
% drop data from the end of the file
remainder = mod(m,binby);
M = M(1:(end-remainder),:);
[m,n]=size(M); %M is the original matrix

% reshaping and summing
M=sum( reshape(M,p,[]) ,1 );
M=reshape(M,m/p,[]).'; %Note transpose

M=sum( reshape(M,q,[]) ,1);
M=reshape(M,n/q,[]).'; %Note transpose

x = M(:,1)/binby;
y = M(:,2);
end