% script to getting the peak deconvolved composition for many pos files
% with range files at once.
% A. London Oct 2013
load('batchDecomp2015Data3.mat'); % load data instead
selectedData = [97,99];
selectedData = [selectedData selectedData+108]; % cluster and matrix data sets
%get data
aptRoot = 'C:\Users\andy\APT\';
cfRoot = 'C:\Users\andy\APT\clusterAnalysis\';
clrRangeRoot = 'C:\Users\andy\APT\ranges\';
matrixRangeRoot = 'C:\Users\andy\APT\ranges\matrix\';
[d,cols]=dataBase('run>0',1); % get all data form datBase
clrRangeFileList = strcat(clrRangeRoot, regexprep(d(:,strcmp('rrng',cols)),'\.rrng','ss_80.rrng','ignorecase'));
matrixRangeFileList = strcat(matrixRangeRoot, regexprep(d(:,strcmp('rrng',cols)),'\.rrng','ss_80.rrng','ignorecase'));
posFileList = strcat(d(:,strcmp('reconRoot',cols)), d(:,strcmp('pos',cols)));
clrPosList = regexprep(d(:,strcmp('clrIdxRrng',cols)),'\.indexed\.rrng','.pos','ignorecase');
matrixPosList = regexprep(d(:,strcmp('clrIdxRrng',cols)),'\.cluster\.indexed\.rrng','.matrix.pos','ignorecase');
overlapList = [d(:,strcmp('overlaps',cols));d(:,strcmp('overlapsMatrix',cols))];

% extra stuff for cluster/matrix comps
rangeFileList = [clrRangeFileList; matrixRangeFileList];
% add matrix and cluster file endings
posFileList = [clrPosList; matrixPosList];
% first half matrix
% second half cluster
num_files = length(posFileList);

for n = selectedData
    try
        for o=1:length(overlapList{n})
            addOverlapIonsToRangeFile(overlapList{n}{o},rangeFileList{n});
        end
        [deconvCounts{n},asRangedCounts{n},rangeOutput{n},rangeTableDecomp{n}]=massDecomp(rangeFileList{n},posFileList{n},overlapList{n});
    catch
        rf = regexprep(rangeFileList{n},'ss_80\.rrng','s_80.rrng','ignorecase');
        for o=1:length(overlapList{n})
            addOverlapIonsToRangeFile(overlapList{n}{o},rf);
        end
        [deconvCounts{n},asRangedCounts{n},rangeOutput{n},rangeTableDecomp{n}]=massDecomp(rf,posFileList{n},overlapList{n});
    end
end
% export data
elements = vertcat(rangeOutput{:});
elements = unique(elements)';
headers = {'run','mat','matCode','irrdT1','irrdDpa1','irrdT2','irrdDpa2'};
exprt=cell(num_files*2 + 1,(length(elements)+length(headers)+2));
for n=1:num_files
   [~,loc]=ismember(rangeOutput{n},elements);
   exprt(n+1,loc) = num2cell(deconvCounts{n}./sum(deconvCounts{n}));
   exprt(num_files+n+1,loc) = num2cell(asRangedCounts{n}./sum(asRangedCounts{n}));
end
for i=1:length(headers)
    exprt(2:end,length(elements)+i) = repmat(d(:,strcmp(headers{i},cols)),4,1);
end
exprt(2:end,end-1) = [repmat({'Deconv'},num_files,1);repmat({'AsRanged'},num_files,1)];
exprt(2:end,end) = [repmat({'cluster'},num_files/2,1);repmat({'matrix'},num_files/2,1);repmat({'cluster'},num_files/2,1);repmat({'matrix'},num_files/2,1)];
exprt(logical(cell2mat(cellfun(@isempty,exprt,'uni',0))))={0};
exprt(1,:) = [elements headers {'method','type'}];
cell2csv('deconvolutedComposition2015d.csv',exprt);
save('batchDecomp2015Data4');