% script to getting the peak deconvolved composition for many pos files
% with range files at once.
% A. London Oct 2013

%get data
aptRoot = 'C:\Users\andy\APT\';
[d,cols]=dataBase('run>0',1); % get all data form datBase
rangeFileList = strcat(aptRoot, d(:,strcmp('rrng',cols)));
posFileList = strcat(d(:,strcmp('reconRoot',cols)), d(:,strcmp('pos',cols)));
opts = {'Irrd'};
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);
opts = {'UnirrdFull'};
[rangeFileList2,posFileList2,clusterFileList2,volList2,matList2]=clusterFiles(opts);
rangeFileList = [rangeFileList rangeFileList2];
posFileList = [posFileList; posFileList2];
clusterFileList = [clusterFileList clusterFileList2];
volList = [volList volList2];
matList = [matList matList2];
matList = [matList matList]; % make it double

% extra stuff for cluster/matrix comps
rangeFileList((length(rangeFileList)+1):2*length(rangeFileList)) = rangeFileList; % double it!
posFileList = regexprep(posFileList,'\.pos',''); % remove pos sufix
posFileList((length(posFileList)+1):2*length(posFileList)) = posFileList; % double it!
% add matrix and cluster file endings
posFileList(1:length(posFileList)/2) = strcat(posFileList(1:length(posFileList)/2),'.matrix.pos');
posFileList((1+length(posFileList)/2):end) = strcat(posFileList((1+length(posFileList)/2):end),'.cluster.pos');
% first half matrix
% second half cluster
num_files = length(posFileList);
deconvCounts = cell(num_files,1);
asRangedCounts = cell(num_files,1);
rangeOutput = cell(num_files,1);
rangeTableDecomp = cell(num_files,1);
for n = 1:num_files
    if strcmp(matList{n}(1),'B') || strcmp(matList{n},'Fe ODS')
        % No Cr
        overlaps{1} = {{1,'C',2} {2,'Ti'}};
        overlaps{2} = {{2,'Ti','O'} {1,'O',2}};
        overlaps{3} = {{3,'Y','O'} {2,'Fe','N'}};
        overlaps{4} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
    else
        % Has Cr
        overlaps{1} = {{1,'C',2} {2,'Ti'} {2,'Cr'} {2,'Fe'}};
        overlaps{2} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'} {3,'Y','O'} {2,'Fe','N'}};
        overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
    end
    [deconvCounts{n},asRangedCounts{n},rangeOutput{n},rangeTableDecomp{n}]=massDecomp(rangeFileList{n},posFileList{n},overlaps);
end