% silly reconstuction of ionic range data after running batchDecomposition
% should just be saving the data in the first place.
load('batchDecomp2015Data.mat');
%rangeByIonResults = cell(length(posFileList),1); % sort results here
%ionResults = cell(length(posFileList),2);
for i = 1:length(posFileList)
    [element_num, range_num, elements, ranges] = rangeReader (rangeFileList{i});
    elementalRangeTab = cell2mat(ranges(:,5:end));
    [ionicRangeTable,rangeIonStr,rangeIons]=elemental2ionicRangeTab(elementalRangeTab,elements,ranges);
    % also need the ions from overlaps to include with ions
    overlapIons =  horzcat(overlapList{i}{:});
    overlapIonsStr = ions2ionStrChrg(overlapIons);
    totalIonStr = [rangeIonStr overlapIonsStr'];
    totalIons = [rangeIons overlapIons];
    [ionNames, ia]=unique(totalIonStr);
    ionq = totalIons(ia); % unique ions in cell definition
    ionAbund = peakHeights(ionq); % make theoretical peak centre by ions table of abundancies
    % pick out only which ion is in which range
    ionAbund(:,2:end)=ionAbund(:,2:end)>0;
    a=rangeTableDecomp{i}(:,1:2);
    b=sort(a(:));
    [n,bin]=histc(ionAbund(:,1),b);
    cn = cumsum(n); % accumulate n, then every other entry is the bin position in ionAbundance
    rangeToionAbund = cn(1:2:end); % take every other value
    % this tells us which ranges have which ions in (also which ions are not
    % ranged)
    %presentIons = sum(ionAbund(rangeToionAbund,2:end),1)>0;
    rangeToIon = ionAbund(rangeToionAbund,2:end);
    ionByEle = ions2ionTable(ionq,rangeOutput{i});
    rangeByIon = zeros(size(rangeTableDecomp{i},1),length(ionNames));
    for r=1:size(rangeTableDecomp{i},1)
        % in this range which ions are there?
        ionByEleR = repmat(rangeToIon(r,:)',1,length(rangeOutput{i})).*ionByEle;
        rangeByIon(r,:) = rangeTableDecomp{i}(r,3:end)/ionByEleR;
    end
    rangeByIonResults{i} = rangeByIon;
    ionResults{i,1} = ionNames;
    ionResults{i,2} = ionq;
    % plot bar chart
    l=cell(1,size(rangeTableDecomp{i},1));
    for r=1:size(rangeTableDecomp{i},1)
        l{r}=strcat(ionNames(rangeByIon(r,:)>0.01));
    end
    if sum(cell2mat(cellfun(@isempty,l,'uni',0)))
        warning(['missing elements:' rangeFileList{i}]);
        l(cell2mat(cellfun(@isempty,l,'uni',0))) = {{'NULL'}};
    end
    ls = cellfun(@(x) strcat(x{:}),l,'uni',0); % make text labels
    bar(rangeByIon,'stacked');
    xText = text(1:size(rangeTableDecomp{i},1), zeros(1,size(rangeTableDecomp{i},1)) , num2str(rangeTableDecomp{i}(:,1)));
    set(xText, 'VerticalAlignment','middle', 'FontSize',8, 'rotation',90);
    hText = text(1:size(rangeTableDecomp{i},1), ones(1,size(rangeTableDecomp{i},1)) , ls);
    set(hText, 'VerticalAlignment','middle', 'FontSize',8, 'rotation',90);
    legend(ionNames,'Location','EastOutside');
    title(posFileList{i});
    ylim([0,1.2]);
    [path,name]=fileparts(posFileList{i});
    set(gcf, 'PaperPosition', [0 0 25 20]); % set figure size
    saveas(gca,['ionicComp' name '.png']); % save figure
end