% batch decomp Export
% after running batchDecomposition use this script to get the data in a
% more readable format.
elements = {'Fe', 'Cr', 'Y', 'Ti', 'O', 'C', 'N'};
exportTableRaw = cell(num_files+1,length(elements)+4);
exportTableRaw(1,:) = [elements 'mat' 'irrdTemp' 'run' 'mc']; % headings
[material,irrdTemp] = codeConvert(matList);
% run list:
runList = regexprep(rangeFileList,'C:\\Users\\Andy\\APT\\','');
runList = regexprep(runList,'.rrng','');
for i = 1:num_files
    for e = 1:length(elements)
        % select elements from the raw data
        a = deconvCounts{i}(strcmp(elements(e),rangeOutput{i}));
        if isempty(a)
            exportTableRaw{i+1,e} = 0;
        else
            exportTableRaw{i+1,e} = a;
        end
    end
    if i<=(num_files/2)
        mc = 'Matrix';
    else
        mc = 'Cluster';
    end
    exportTableRaw(i+1,end-3:end) = [material(i) irrdTemp(i) runList(i) mc];
end
counts = cell2mat(exportTableRaw(2:end,1:end-4));
total = sum(counts,2);
comp = 100*counts./repmat(total,1,length(elements));
exportTableComp = exportTableRaw;
exportTableComp(2:end,1:end-4) = num2cell(comp);
solute = cell2mat(exportTableRaw(2:end,3:5));
totalS = sum(solute,2);
exportTableSol = exportTableRaw(:,[3 4 5 end-3:end]);
exportTableSol(2:end,1:end-4) = num2cell(100*solute./repmat(totalS,1,3));
exportTableCompErrs = [exportTableComp(:,1:length(elements)) exportTableComp(:,:)];
exportTableCompErrs(1,1:length(elements)) = strcat(exportTableCompErrs(1,1:length(elements)),'err');
exportTableCompErrs(2:end,1:length(elements))= num2cell(comp./sqrt(counts));

% matrix correction
crRatio = counts(1:num_files/2,2)./counts(1:num_files/2,1);
crRatio(crRatio>0.12) = 0.12; % set upper limit to exlcude surface oxides
crCorr = counts((num_files/2+1):end,2)-crRatio.*counts((num_files/2+1):end,1);
soluteC = [crCorr cell2mat(exportTableRaw((num_files/2+2):end,3:5))];
totalSC = sum(soluteC,2);
exportTableCor = exportTableComp(1,[2:5 end-3:end]); % copy headers
exportTableCor(2:(num_files/2+1),1:4) = num2cell(100*soluteC./repmat(totalSC,1,4)); 
exportTableCor(:,end-3:end) = exportTableRaw(1:(1+num_files/2),end-3:end);
% removes mc (matrix/cluster) column
exportTableCor = exportTableCor(:,1:end-1);
if(1)    % write output file of composition?
    e2 = strCellConvert(exportTableComp); % add str limiters
    cell2csv('comp3Yex.csv',e2,',')
end
if(0)    % write output file of matrix correct composition?
    e2 = strCellConvert(exportTableCor); % add str limiters
    cell2csv('comp3Ymatcor.csv',e2,',')
end