% new batch composition script with optional "ignore oxide depth setting"
% get dat files
d=dataBase('mat=Fe14Cr',1);
oxideDepths=[0 0 70 38 0 42 0]; % in nm
rangeLevel = 0.9; % FW(1-X)M
froot='C:\Users\andy\APT\'; % directory root
% get oxide depths is the same length as d
% get pos files and range files
clusterPosCol = 20; % column in data file of .cluster.indexed.rrng
rangeFileCol = 22; % column of range files
posList=cell(size(d,1),1);
rangeList = strcat(froot,d(:,rangeFileCol));
for i=1:length(posList)
   [mat,idx]=regexp(d(i,clusterPosCol),'[\w\\\:\s\-\.]+(?<=\-v0\d)');
   posList{i} =  strcat(d{i,clusterPosCol}(1:idx{1}),'.pos');
end
% run "range corrector"
% for n = 6:size(posList,1)
%     result = rangeCorrector(rangeList{n},posList{n},rangeLevel);
% end
% run range counter
% need to do a peak decomposition here....
% comp = cell(14,3,length(posList));
% ranges = cell(100,17,length(posList));
% for n = 1:size(posList,1)
%    range = strcat(regexprep(rangeList{n},'(\.rrng)|(\.RRNG)',''),['_',num2str(rangeLevel*100),'.rrng']);
%    [c1, c2] = rangeCounter(range,posList{n});
%    comp(1:size(c1,1),1:size(c1,2),n) = c1;
%    ranges(1:size(c2,1),1:size(c2,2),n) = c2;
%    %pk32(1:size(c3,1),1:size(c3,2),n) = c3;
% end
num_files = size(posList,1);
deconvCounts = cell(num_files,1);
asRangedCounts = cell(num_files,1);
rangeOutput = cell(num_files,1);
rangeTableDecomp = cell(num_files,1);
for n = 1:num_files
    if 0
        % No Cr
        overlaps{1} = {{1,'C',2} {2,'Ti'}};
        overlaps{2} = {{2,'Ti','O'} {1,'O',2}};
        overlaps{3} = {{3,'Y','O'} {2,'Fe','N'}};
        overlaps{4} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
    else
        % Has Cr
        overlaps{1} = {{1,'C',2} {2,'Ti'} {2,'Cr'} {2,'Fe'}};
        overlaps{2} = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'} {3,'Y','O'} {2,'Fe','N'}};
        overlaps{3} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
    end
    [deconvCounts{n},asRangedCounts{n},rangeOutput{n},rangeTableDecomp{n}]=massDecomp(rangeFileList{n},posList{n},overlaps);
end