% This script reads many decomposed clusterData files (from IVAS) and
% outputs a list of materials, irradiation temperatures and x,y,r
% coordinates for a ternary diagram
% A. London June 2013

% example data read 'conversion' to an xls file:
%clusterDataReader('R14_16731-v01_YTiOYO.csv');
% the above outputs 'R14_*_decomp.xls'
% this can be copied into allClusterAnalysis using batchwrite.m

factors = {'B1' 'B3' 'B2' 'YTi' 'C1' 'C3' 'C2' 'Fe-14Cr'};
materialType = {'Fe-Y-Ti' 'Fe-Y-Ti' 'Fe-Y-Ti' 'Fe-Y-Ti' 'Fe-14Cr' 'Fe-14Cr' 'Fe-14Cr' 'Fe-14Cr'};
IrrdTemp = {500 600 700 0 500 600 700 0};
outputData = cell(1,9); % Original cell array for storing the data
% Material	IrrdTemp	Run     x       y           r
% Fe-14Cr	0           "15202"	0.25	0.17606011	1.596745653


for f = 1:length(factors)
    xlsFiles = fileList(strcmp(fileList,factors(f)),2);
    
    clusterPlot=cell(1);
    minSolute = 0.001; %    specify a minimum solute content (good for removing random clusters)
    minYFraction = 0.05;    % Use this to remove TiO2 surface oxides
    %xlsFiles = {'R14_16416-v02_YO2YO_80_decomp.xls';'R14_15734-v02_YYOTiOO_80_09_decomp.xls'};
    for fileN = 1:length(xlsFiles)
        xlsData=xlsread(xlsFiles{fileN});
        solutePercent = sum(xlsData(:,3:5),2)./sum(xlsData(:,1:5),2);
        YFrac = xlsData(:,3)./sum(xlsData(:,3:5),2);
        filterVector = (solutePercent>minSolute & YFrac>minYFraction);   
        xlsData = xlsData(filterVector,:);
        clusterPlot{fileN} = xlsData(:,(end-2):end); % only read last 3 columns
        % generate legend text
        S = textscan(xlsFiles{fileN},'R14_%s','delimiter','-');
        tempData = cell(length(clusterPlot{fileN}(:,1)),6);
        tempData(:,1) = {materialType{f}};
        tempData(:,2) = {IrrdTemp{f}};
        tempData(:,3) = {S{1}{1}};
        % Solute percent
        tempData(:,4) = num2cell(solutePercent(filterVector));
        % Y/Ti ratio
        tempData(:,5) =  num2cell(xlsData(:,3)./xlsData(:,5));
        % Y/Ti ratio errors
        tempData(:,6) =  num2cell((xlsData(:,3)./xlsData(:,5)).*sqrt((1./xlsData(:,3))+(1./xlsData(:,5))));
        tempData(:,7:9) = num2cell(clusterPlot{fileN});
        outputData = [outputData; tempData];
    end
    
end