% average comp with voltage
% generate the vertical (voltage) trace of a ternary diagram
% needs the data produced by clusterVoltage
% note: x = voltage per cluster

vscale = 3000; % devide voltage by this
xY = countsDecomp(:,3)./sum(countsDecomp(:,3:5),2)+0.5*countsDecomp(:,5)./sum(countsDecomp(:,3:5),2);
yTi = (countsDecomp(:,5)./sum(countsDecomp(:,3:5),2))*0.866;

terplot(6,1,.025,'%3.1f');
hold all
scatter3(xY,yTi,x/vscale,radii*20);
plot3([.3 .3],[.2*0.866 .2*0.866],[0 2],'r-'); % guiding lines
plot3([.4 .4],[0 0],[0 2],'r-.'); % guiding lines

vslice = 100;
vslices = 0:vslice:(max(x)+vslice);
vindex = 1;
ax = zeros(1,length(vslices)); % average composition
ay = zeros(1,length(vslices));
for v=vslices
    ax(vindex) = mean(xY(x>v & x<=(v+vslice)));
    ay(vindex) = mean(yTi(x>v & x<=(v+vslice)));
    vindex = vindex+1;
end

plot3(ax,ay,vslices./vscale,'g-');
text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
text((.75)+spacing,(.866/2),'Ti fraction','Rotation',0,'HorizontalAlignment','center');
text((.25)-spacing,(.866/2),'O fraction','Rotation',0,'HorizontalAlignment','center');
hold off