function [weightTable] = atomic2weightTable(atomicTable)
% [weightTable] = atomic2weightTable(atomicTable)
% takes a table of elements (rows), their atomic percent (2nd column) and
% optionaly the error (3rd column),
% and converts them using the isotopes.mat file into a weight percent table

if ~iscell(atomicTable)
    error('atomicTable should be a cell array');
end
if size(atomicTable,2)>2
    e = 1; % includes error
end
if sum(cell2mat(atomicTable(:,2)))<100
    warning('Adding iron to make to 100%');
    if e
        atomicTable(end+1,:) =  {'Fe',100-sum(cell2mat(atomicTable(:,2))),0};
    else
        atomicTable(end+1,:) =  {'Fe',100-sum(cell2mat(atomicTable(:,2)))};
    end
end
elements = atomicTable(:,1);

% read isotopes file - required file
if(exist('isotopes.mat','file'))
    isotopes = open('isotopes.mat');
    isotopes = isotopes.isotopes;
else
    disp('isotopes.mat file not found!');
end
elementM = zeros(length(elements),1);
for e=1:length(elements)
    % mass and abundance
    mAb = cell2mat(isotopes(~cell2mat((cellfun(@isempty,strfind(isotopes(:,1),[elements{e} '(']),'uni',0))),2:3));
    elementM(e) = mAb(:,1)'*mAb(:,2)/100;
end

weights = elementM.*cell2mat(atomicTable(:,2));

weightTable = 100*weights./sum(weights);

if e
   perrors = cell2mat(atomicTable(:,3))./cell2mat(atomicTable(:,2));
   weightTable = [elements num2cell(weightTable) num2cell(weightTable.*perrors)];
else
    weightTable = [elements num2cell(weightTable)];
end
end