function y = asyGaussTail(p,x)
% asymmetric peak produced by the convolution of two exponential functions
% and a gaussian.
xg = p(1); % x position
sg = p(2); % gaussian width
lamda = p(3); % asymmetry value
% p(4) is a scaling constant
% p(5) is a noise level constant
% p(6) is the decay shift 
% p(7) is the decay contanst 
% p(8) is the magnitude of the decay
y = p(5)+p(4)*(1/2*abs(lamda))*(1-erf(...
    (((xg-x)*lamda)/(sg*abs(lamda)*1.4142))+...
    sg/(abs(lamda)*1.4142)...
)).*exp(...
((xg-x)/lamda)+(sg*sg)/(2*lamda*lamda)...
);
% add in tail
y = y - mdlexp([0 p(6) p(7) p(8)],x);
% note p(5) noise floor is used twice

%[maximumY maxIndex] = max(y);
%disp(maximumY);
% (1-y(maxIndex:end)./maximumY).*
% fit the decay tail
%y((maxIndex+1):end) = y(maxIndex+1:end)+(p(4)*p(6))*exp(-p(7)*sqrt(abs(xg-x(maxIndex+1:end))));
%y((maxIndex+1):end) = y(maxIndex+1:end)+p(6)*exp(-(p(7)+xg-x(maxIndex+1:end)));
% old
% y = p(5)+p(4)*(1/2*abs(lamda))*(1-erf(...
%     (((xg-x)*lamda)/(sg*abs(lamda)*1.4142))+...
%     sg/(abs(lamda)*1.4142)...
% )).*exp(...
% ((xg-x)/lamda)+(sg*sg)/(2*lamda*lamda)...
% );

%y = ((1/2*abs(lamda))*(1-erf(xg-x))).*exp(x);
end