function y = asyGaussNoNoise(p,x)
% asymmetric peak produced by the convolution of two exponential functions
% and a gaussian.
xg = p(1); % x position
sg = p(2); % gaussian width
lamda = p(3); % asymmetry value
% p(4) is a scaling constant
% p(5) is a noise level constant (pre) % 3/5/13 removed
% p(6) is a noise level constant (post) % 5/12/12 removed

y = p(4)*(1/2*abs(lamda))*(1-erf(...
    (((xg-x)*lamda)/(sg*abs(lamda)*1.4142))+...
    sg/(abs(lamda)*1.4142)...
)).*exp(...
((xg-x)/lamda)+(sg*sg)/(2*lamda*lamda)...
);
y=double(y);
% removed pre/post noise level
% removed p(5) to below - separate noise floors front and back
%[maximumY maxIndex] = max(y);
%y(1:maxIndex-1) = y(1:maxIndex-1) + p(5);
%y(maxIndex:end) = y(maxIndex:end) + p(6);
end