function y = asyGauss2(p,x)
% asymmetric peak produced by the convolution of two exponential functions
% and a gaussian.
xg = p(1); % x position
sg = p(2); % gaussian width
lamda = p(3); % asymmetry value
% p(4) is a scaling constant
xg2 = p(6); % x position
sg2 = p(7); % gaussian width
lamda2 = p(8); % asymmetry value
% p(9) is a scaling constant

% p(5) is a noise level constant (pre) 
% p(6) is a noise level constant (post) % removed 5/12/12

y = p(4)*(1/2*abs(lamda))*(1-erf(...
    (((xg-x)*lamda)/(sg*abs(lamda)*1.4142))+...
    sg/(abs(lamda)*1.4142)...
)).*exp(...
((xg-x)/lamda)+(sg*sg)/(2*lamda*lamda)...
)+...
p(9)*(1/2*abs(lamda2))*(1-erf(...
    (((xg2-x)*lamda2)/(sg2*abs(lamda2)*1.4142))+...
    sg2/(abs(lamda2)*1.4142)...
)).*exp(...
((xg2-x)/lamda2)+(sg2*sg2)/(2*lamda2*lamda2)...
)+p(5);

% removed p(5) to below - separate noise floors front and back
%[maximumY maxIndex] = max(y);
%y(1:maxIndex-1) = y(1:maxIndex-1) + p(5);
%y(maxIndex:end) = y(maxIndex:end) + p(6);
%disp(maximumY);
end