function [ionRanges]=associateIonsToRanges(ranges,elements,ions)
%[ionRanges]=associateIonsToRanges(ranges,elements,ions)
% From a range table (returned by rangeReader), a cell array of elements
% (returned by rangeReader) and a list of possible ions (natural name
% ion format, see below); return the relation between which range contains
% which ion number. This ignores charge states.
% E.g. ranges = 23.9 24.1 0 0 0 2, elements = {'Fe','O','Y','C'},
% ions = {'Fe','C2','YO','O'} = Fe+ C2+ YO++ O+
% then ionRanges = (1,2) = range1 is ion 2
% A London Feb 2015

% range table, size = ranges-by-elements
rangeTable = cell2mat(ranges(:,5:end));
assert(size(rangeTable,2)==length(elements),'ranges size is invalid with length of elements list');

% ion table from ions list, size = ions-by-elements
[newIonTable,newEle] = ions2ionTable(ionStr2ions(ions(:,1)));

% find original elements in new elements
[eleLogic,ie]=ismember(elements,newEle);
p = zeros(1,size(newIonTable,2));
p(ie) = 1;
% remove rows (ions) which contain elements not defined in ranges
keeprows = ~(sum(newIonTable(:,~logical(p)),2)>0);

% check rows from rangeTable against newIonTable to find the ranges -> ions
%   relation
[loc,rangeToPossibleIon] = ismember(rangeTable,newIonTable(keeprows,ie),'rows');
%peaks = peakHeights(ionStr2ions(ions(keeprows,1))); % get theoretical peak centres
% use ~approximate range centres
ionRanges = [mean(cell2mat(ranges(:,1:2)),2) rangeToPossibleIon];
end