function addOverlapIonsToRangeFile(ions,rangeFile)
[element_num, range_num, elements, ranges] = rangeReader (rangeFile);
%addOverlapIonsToRangeFile(ions,elements,rangeFile)
% given a list of ions and check the elements in ions exist in
% elements, if there are missing elements add them in to the rangeFile
ion_num = length(ions);
u = horzcat(ions{:});
% check the elements in overlaps are in the supplied elements list
olelements = unique(u(cellfun(@ischar,u)),'stable');
missingEle = logical(zeros(1,length(olelements)));
for i = 1:length(olelements)
    if ~sum(strcmp(olelements{i},elements))
        warning(strcat('Could not find:',olelements{i},' in the elements list'));
        missingEle(i) = 1;
    end
end
if sum(missingEle)
    disp(rangeFile);
    % there are missing elements
    % amend elements list and ranges
    elements = [elements' olelements(missingEle)];
    ranges = [ranges num2cell(zeros(size(ranges,1),sum(missingEle)))];
    [~] = rangeWriter( ranges, elements, regexprep(rangeFile,'\.rrng','','ignorecase'));
end
end