% SRIM recoil distribution fit
% load sample data
%filename = 'C:\Users\andy\SRIM-2013\SRIM Outputs\Fe-1760kev-particle10000\RANGE.txt';
%startRow = 41;
filename = 'C:\Users\andy\SRIM-2013\SRIM Outputs\Fe-1760kev-1Aparticle10000\RANGE.txt';
startRow = 40;

solutes = [4 5 6];
RANGE = importfileSRIM(filename, startRow);

displacements = sum(RANGE(:,solutes),2);
x = RANGE(:,1);
%% pick centre
% graphical method
%semilogy(x,displacements);
%[cx,cy]=ginput(1);
% peaks method
[pks,locs]=findpeaks(displacements,'SORTSTR','descend','NPEAKS',1);
cx = x(locs);
xx = x-cx; % centre data
%% build convolution function
ldisps = log(displacements);
nnans = ~(isnan(ldisps)|isinf(ldisps));
iL = zeros(size(ldisps)); iL(locs:end) = 1; iL=logical(iL);
iR = zeros(size(ldisps)); iR(1:locs) = 1; iR=logical(iR);
[fLeft, gof1] = exp2fit(xx, log(displacements), find(iL(nnans)));
[fRight, gof2] = exp2fit(xx, log(displacements), find(iR(nnans)));
% add together
f = zeros(size(xx));
centreValue = mean([fRight(0) fLeft(0)]);
f(locs:end) = fRight(xx(locs:end));
f(1:locs) = fLeft(xx(1:locs));
f(locs) = centreValue;

%% model system
mat=zeros(length(ldisps),1);mat(49:53)=1;
% convolute
a=conv(mat,exp(f),'same');
% plot fit
semilogy(xx,a,xx,displacements*14)