%% Import data from text file.
% Script for importing data from the following text file:
%
%    C:\Users\andy\SRIM-2011\SRIM Outputs\Fe-5MeV-0\VACANCY0.txt
%
% To extend the code to different selected data or a different text file,
% generate a function instead of a script.

% Auto-generated by MATLAB on 2014/07/25 12:08:13

%% Initialize variables.

filename = strcat('C:\Users\andy\SRIM-2011\SRIM Outputs\Fe-1760kev\VACANCY',num2str(num),'.txt');
startRow = 29;
endRow = 128;

%% Format string for each line of text:
%   column1: double (%f)
%	column2: double (%f)
%   column3: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%11f%13f%13f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
textscan(fileID, '%[^\n\r]', startRow-1, 'ReturnOnError', false);
dataArray = textscan(fileID, formatSpec, endRow-startRow+1, 'Delimiter', '', 'WhiteSpace', '', 'ReturnOnError', false);

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Create output variable
VACANCY0 = [dataArray{1:end-1}];
x = VACANCY0(:,1);
v(:,num+1) = sum(VACANCY0(:,2:3),2);
%% Clear temporary variables
clearvars filename startRow endRow formatSpec fileID dataArray ans;