%Rnw2Lyx converter
% read Rnw file
RnwFile = 'C:\Users\andy\Documents\lp_unirrdRg.Rnw';
lyxFile = 'C:\Users\andy\Documents\lp_unirrdRg.lyx';
% read whole Rnw first to get number of chunks
wholefile = fileread(RnwFile);
num_chunks = sum(strfind(wholefile,'<<')>0);
fid = fopen(RnwFile);
tline = fgets(fid);
cflag = 0;
currentChunk = cell(1);
i=1; j=1;
chunkData = cell(num_chunks,2); % {opts,{chunk contents}}
while ischar(tline)
    % escape back slashes:
    tline = regexprep(tline,'\\','\n\\backslash\n');
    % is chunk header?
    if strfind(tline,'<<')
        chunkData{i,1} = regexp(tline,'(?<=<<)[^<>]+(?=>>)', 'match');
        cflag = 1;
    elseif cflag == 1 && ~sum(strfind(tline,'@'))
        % read line into current chunk
        % escape backslashes
        currentChunk{j} = tline;
        j = j + 1;
    elseif cflag == 1 && strfind(tline,'@')
        % end of chunk
        chunkData{i,2} = currentChunk';
        i=i+1;
        currentChunk = cell(1);
        j=1;
        cflag = 0;
    end
    tline = fgets(fid);
end
fclose(fid);
fid=fopen(lyxFile,'w');
% header
fprintf(fid,'%s\n','#LyX 2.1 created this file. For more info see http://www.lyx.org/');
fprintf(fid,'%s\n','\lyxformat 474');
fprintf(fid,'%s\n','\begin_document');
fprintf(fid,'%s\n','\begin_header');
fprintf(fid,'%s\n','\textclass article');
fprintf(fid,'%s\n','\use_default_options true');
fprintf(fid,'%s\n','\begin_modules');
fprintf(fid,'%s\n','knitr');
fprintf(fid,'%s\n','\end_modules');
fprintf(fid,'%s\n','\maintain_unincluded_children false');
fprintf(fid,'%s\n','\language english');
fprintf(fid,'%s\n','\language_package default');
fprintf(fid,'%s\n','\inputencoding auto');
fprintf(fid,'%s\n','\fontencoding global');
fprintf(fid,'%s\n','\font_roman default');
fprintf(fid,'%s\n','\font_sans default');
fprintf(fid,'%s\n','\font_typewriter default');
fprintf(fid,'%s\n','\font_math auto');
fprintf(fid,'%s\n','\font_default_family default');
fprintf(fid,'%s\n','\use_non_tex_fonts false');
fprintf(fid,'%s\n','\font_sc false');
fprintf(fid,'%s\n','\font_osf false');
fprintf(fid,'%s\n','\font_sf_scale 100');
fprintf(fid,'%s\n','\font_tt_scale 100');
fprintf(fid,'%s\n','\graphics default');
fprintf(fid,'%s\n','\default_output_format default');
fprintf(fid,'%s\n','\output_sync 0');
fprintf(fid,'%s\n','\bibtex_command default');
fprintf(fid,'%s\n','\index_command default');
fprintf(fid,'%s\n','\paperfontsize default');
fprintf(fid,'%s\n','\spacing single');
fprintf(fid,'%s\n','\use_hyperref false');
fprintf(fid,'%s\n','\papersize default');
fprintf(fid,'%s\n','\use_geometry false');
fprintf(fid,'%s\n','\use_package amsmath 1');
fprintf(fid,'%s\n','\use_package amssymb 1');
fprintf(fid,'%s\n','\use_package cancel 1');
fprintf(fid,'%s\n','\use_package esint 1');
fprintf(fid,'%s\n','\use_package mathdots 1');
fprintf(fid,'%s\n','\use_package mathtools 1');
fprintf(fid,'%s\n','\use_package mhchem 1');
fprintf(fid,'%s\n','\use_package stackrel 1');
fprintf(fid,'%s\n','\use_package stmaryrd 1');
fprintf(fid,'%s\n','\use_package undertilde 1');
fprintf(fid,'%s\n','\cite_engine basic');
fprintf(fid,'%s\n','\cite_engine_type default');
fprintf(fid,'%s\n','\biblio_style plain');
fprintf(fid,'%s\n','\use_bibtopic false');
fprintf(fid,'%s\n','\use_indices false');
fprintf(fid,'%s\n','\paperorientation portrait');
fprintf(fid,'%s\n','\suppress_date false');
fprintf(fid,'%s\n','\justification true');
fprintf(fid,'%s\n','\use_refstyle 1');
fprintf(fid,'%s\n','\index Index');
fprintf(fid,'%s\n','\shortcut idx');
fprintf(fid,'%s\n','\color #008000');
fprintf(fid,'%s\n','\end_index');
fprintf(fid,'%s\n','\secnumdepth 3');
fprintf(fid,'%s\n','\tocdepth 3');
fprintf(fid,'%s\n','\paragraph_separation indent');
fprintf(fid,'%s\n','\paragraph_indentation default');
fprintf(fid,'%s\n','\quotes_language english');
fprintf(fid,'%s\n','\papercolumns 1');
fprintf(fid,'%s\n','\papersides 1');
fprintf(fid,'%s\n','\paperpagestyle default');
fprintf(fid,'%s\n','\tracking_changes false');
fprintf(fid,'%s\n','\output_changes false');
fprintf(fid,'%s\n','\html_math_output 0');
fprintf(fid,'%s\n','\html_css_as_file 0');
fprintf(fid,'%s\n','\html_be_strict false');
fprintf(fid,'%s\n','\end_header');

fprintf(fid,'%s\n','\begin_body');
for i = 1:size(chunkData,1)
    % make lyx content
    fprintf(fid,'%s\n','\begin_layout Standard');
    fprintf(fid,'%s\n','\begin_inset Flex Chunk');
    fprintf(fid,'%s\n','status open');

    % {chunk options}?
    if cell2mat(cellfun(@isempty,chunkData(i,1),'uni',0))
        fprintf(fid,'\n');
    else
        %{chunk options}
        fprintf(fid,'%s\n','\begin_layout Plain Layout');
        
        fprintf(fid,'%s\n','\begin_inset Argument 1');
        fprintf(fid,'%s\n','status open');
        
        fprintf(fid,'%s\n','\begin_layout Plain Layout');
        % pritn options
        fprintf(fid,'%s\n',chunkData{i,1}{1});
        fprintf(fid,'%s\n','\end_layout');
        
        fprintf(fid,'%s\n','\end_inset');
        
        
        fprintf(fid,'%s\n','\end_layout');
        
    end
    
    
    for j = 1:size(chunkData{i,2},1)
        %{chunk content}
        fprintf(fid,'%s\n','\begin_layout Plain Layout');
        fprintf(fid,'%s',chunkData{i,2}{j}); % no new line
        fprintf(fid,'%s\n','\end_layout');
    end
    
    
    fprintf(fid,'%s\n','\end_inset');
    
    
    fprintf(fid,'%s\n','\end_layout');
end
% footer
fprintf(fid,'%s\n','\end_body');
fprintf(fid,'%s\n','\end_document');
fclose(fid);