%  pdc = [ 4     0     0     4;
%          0     0     0     0;
%          0     2     0     0;
%          2     0     0     4]; % trial pdc

% s/16 would be the actual scale/number of segments
% s is the smallest scale, k is the actual segmentation

pdc = single(rand([16 16 16])>0.9);
opdc = pdc;
k = numel(pdc);
s = size(pdc);
k1 = s(1);
n = sum(pdc(:));
m=n/k;
results = zeros(round(log2(k1)+1),2); % store k and h
results(1,:) = [1 m];
while k1>2
    title(num2str(k1));
    % Inhomogenity measure
    n = sum(pdc(:));
    k = numel(pdc);
    [k1, ~, ~] = size(pdc);
    m = n/k;
    
    % calc h for this size
    pdc3 = (pdc - m).^2;
    h = sum(pdc3(:))*k/(n*(k-1));
    
    % store results
    results(round(log2(k1)+1),:) = [k1 h];
    
    % reduce the size of the matrix
    pdc=redMat(pdc);
end
results