function [ mat2 ] = redMat( mat )
%[ mat ] = redMat( mat ) Reduces a matrix by 2
%   Takes mat and halfs the dimensions and sums the elements
%   For 1D it must be a colum matrix, eg [0 0 0 1]'

% get the size
s = size(mat);
mat2 = zeros(round(s/2));
% get dimension

if(s(2)>1)
    % 2D or % 3D
    if(length(s)>2)
        % 3D
        for k = 1:length(mat(1,1,:))/2
            % reduction of Z
            mat(:,:,k) = mat(:,:,2*k-1) + mat(:,:,2*k);
            for j = 1:length(mat(1,:,k))/2
                % reduction of Y
                temp = mat(:,2*j-1,k)+mat(:,2*j,k);
                for i = 1:length(mat(:,1,k))/2
                    % reduction of X
                    mat2(i,j,k) = temp(2*i-1)+temp(2*i);
                end
            end
        end
    else
        % 2D
        for j = 1:length(mat(1,:))/2
            temp = mat(:,2*j-1)+mat(:,2*j);
            for i = 1:length(mat(:,1))/2
                mat2(i,j) = temp(2*i-1)+temp(2*i);
            end
        end
    end
elseif(s(1)>2)
    % reduce 1D
    for i = 1:length(mat)/2
        mat2(i) = mat(2*i-1)+mat(2*i);
    end
else
    error(strcat('matrix too small, size = ',num2str(s)));
end

