% inhomogeneity trial
% measure inhomogenity using cluster centres and solute positions
load('HData20150223','posSample'); % load 'posSample' (ranges) data
[d,cols]=dataBase('run>0',1); % load data
headers = {'run','mat','matCode','irrdT1','irrdDpa1','irrdT2','irrdDpa2'}; % cell of strings from cols
subdiv = 8; steps=1; % pixel range and step size
contFlag = 0;
H = zeros(size(d,1),((subdiv-2)/steps+1));
h = zeros(size(d,1),((subdiv-2)/steps+1));
gscale = zeros(size(d,1),((subdiv-2)/steps+1));
H2 = zeros(size(d,1),((subdiv-2)/steps+1));
h2 = zeros(size(d,1),((subdiv-2)/steps+1));
gscale2 = zeros(size(d,1),((subdiv-2)/steps+1));
for i=1:size(d,1) % for each file in turn
    % read pos file
    posFile = strcat(d{i,strcmp('reconRoot',cols)},d{i,strcmp('pos',cols)});
    disp(posFile);
    cf = strcat('C:\users\andy\apt\clusterAnalysis\',d{i,strcmp('cf',cols)});
    %[ranges,posVolume(i)]=maxBox(posFile,8000,10000);
    %ranges = ranges';
    ranges = posSample{i}; % load cahced data
    [~,~,~,positions] = clusterExtent(cf);
    positions = positions(~(sum(positions<repmat(ranges(:,1)',size(positions,1),1),2) | sum(positions>repmat(ranges(:,2)',size(positions,1),1),2)),:);
    [H(i,:),h(i,:),gscale(i,:),~]=inK(ranges,positions,subdiv,steps);
    
    % get solute ion positions:
    [pathstr, name, ext] = fileparts(d{i,strcmp(cols,'clrIdxRrng')}); 
    spos = [pathstr '/' regexprep(name,'indexed','solute.pos')];
    if exist(spos,'file')
        [x,y,z,~]=readpos(spos);
    else
        spos = [pathstr '/' regexprep(name,'indexed','pos')];
        [x,y,z,~]=readpos(spos);
    end
    p = x>ranges(1,1) & x<ranges(1,2) & y>ranges(2,1) & y<ranges(2,2) & z>ranges(3,1) & z<ranges(3,2);
    [H2(i,:),h2(i,:),gscale2(i,:),~]=inK(ranges,[x(p)' y(p)' z(p)'],subdiv,steps);
    clear x y z p
end
% export data (points):
exprt = cell(numel(H),length(headers)+2);
for i=1:length(headers)
    exprt(:,i) = reshape(repmat(d(:,strcmp(headers{i},cols)),1,((subdiv-2)/steps+1))',[],1); % runs
end
exprt(:,length(headers)+1) = num2cell(reshape(H',[],1)); % H
exprt(:,length(headers)+2) = num2cell(reshape(gscale',[],1)); % gscale
exprt = [[headers,{'H','gscale'}];exprt];
cell2csv('Hmeasure2-points.csv',exprt);

% export data (ions):
exprt = cell(numel(H2),length(headers)+2);
for i=1:length(headers)
    exprt(:,i) = reshape(repmat(d(:,strcmp(headers{i},cols)),1,((subdiv-2)/steps+1))',[],1); % runs
end
exprt(:,length(headers)+1) = num2cell(reshape(H2',[],1)); % H
exprt(:,length(headers)+2) = num2cell(reshape(gscale2',[],1)); % gscale
exprt = [[headers,{'H','gscale'}];exprt];
cell2csv('Hmeasure2-ions.csv',exprt);