% measure inhomogenity
[d,cols]=dataBase('run>0',1); % load data
headers = {'run','mat','matCode','irrdT1','irrdDpa1','irrdT2','irrdDpa2'}; % cell of strings from cols
subdiv = 8; steps=0.05; % pixel range and step size
contFlag = 0;
H = zeros(size(d,1),((subdiv-2)/steps+1));
h = zeros(size(d,1),((subdiv-2)/steps+1));
gscale = zeros(size(d,1),((subdiv-2)/steps+1));
for i=1:1%size(d,1) % for each file in turn
    % read pos file
    posFile = strcat(d{i,strcmp('reconRoot',cols)},d{i,strcmp('pos',cols)});
    disp(posFile);
    cf = strcat('C:\users\andy\apt\clusterAnalysis\',d{i,strcmp('cf',cols)});
    % get file size
    fileInfo = dir(posFile);
    fileSize = fileInfo.bytes;
    % read only .9 (90%) of the file instead:
    [x,y,z,~]=readpospart(posFile,round(.90*(fileSize/16)),fileSize/16);
    %[x,y,z,~]=readpos(posFile);
    ranges = [min(x) max(x);min(y) max(y);0 max(z)];
    clear x y z
    [~,~,~,positions] = clusterExtent(cf);
    [H(i,:),h(i,:),gscale(i,:),~]=inK(ranges,positions,subdiv,steps);
    if contFlag
        try
            [A1,b1,c1,~]=inK_control(ranges,positions,subdiv,steps);
        catch
            [A1,b1,c1,~]=inK_control(ranges,positions,subdiv,steps);
        end
        plot(gscale(i,:),H(i,:),'k-',c1,A1,'r-');title(num2str(d{i,1}));
        saveas(gcf,['Inhomogenity\inhomogen' num2str(d{i,1}) '.png']);
    end
end
% export data:
exprt = cell(numel(H),length(headers)+2);
for i=1:length(headers)
    exprt(:,i) = reshape(repmat(d(:,strcmp(headers{i},cols)),1,((subdiv-2)/steps+1))',[],1); % runs
end
exprt(:,length(headers)+1) = num2cell(reshape(H',[],1)); % H
exprt(:,length(headers)+2) = num2cell(reshape(gscale',[],1)); % gscale
exprt = [[headers,{'H','gscale'}];exprt];
cell2csv('Hmeasure2.csv',exprt);