function [H,h,gscale,PDC]=inK_control(ranges,positions,subdiv,steps)
% [H,h,gscale,PDC]=inK_control(ranges,positions,subdiv,steps)
% Garncarek measure of spatial inhomogenity - with randomised positions
% ranges = [min(x) max(x);min(y) max(y);min(z) max(z)]; % in nm
% positions = [x y z] n-by-3, in nm
% subdiv = max number of sub-divisions

l = ranges(:,2)-ranges(:,1); % lengths
pix = min(l)/(2^subdiv); % voxel length in nm
s = prod(l)/(pix^3); % volume expressed in the smallest unit cell
klist = [2:steps:subdiv];
% randomise positions
r = (rand(size(positions,1),1)*mean(l(1:2))/2); % random radii
t = (rand(size(positions,1),1)*pi*2); % random theta
z = (rand(size(positions,1),1)*l(3)); % random theta
positions = [r.*cos(t)-ranges(1,1) r.*sin(t)-ranges(2,1) z];
positions(positions(:,1)>l(1),1) = l(1);
positions(positions(:,2)>l(2),2) = l(2); 
positions(positions(:,3)>l(3),3) = l(3); % check is in range
%positions = positions-repmat(min(ranges'),size(positions,1),1); % shift origin
%generate families of Population distribution charts (PDCs)
PDC = cell(1,length(klist));
n = size(positions,1); % total number of objects
h = zeros(1,length(klist)); % measure h of the degree of inhomogeneity
H = zeros(1,length(klist)); % improved 3-sigma test = (h-E(h))/sigma(h)
gscale = zeros(1,length(klist));
for ik=1:length(klist)
    k=klist(ik);
    % generate reference lattice
    lk = ceil(l./(pix*2^k)); % length in unit cells of each x,y & z
    ii = floor(positions./(pix*2^k))+1; % [ix iy iz] indicies
    iii = sub2ind(lk',ii(:,1),ii(:,2),ii(:,3)); % linear indicies
    PDC{ik} = accumarray(iii,1,[],@sum,0,true); % sparse, sums of 'hits'
    % end of data transformation
    K = prod(lk);
    %gscale(k+1) = s/K; % greater scale from 1 (smallest) -> s
    gscale(ik) = (pix*2^k); % current voxel Size
    h(ik) = (-n/(K-1))+(K/(n*(K-1)))*full(sum(PDC{ik}.^2));
    H(ik) = sqrt((n*(K-1))/(2*(n-1)))*(((1-n-K)/(K-1)) + (K/(n*(K-1)))*full(sum(PDC{ik}.^2)) );
end

