function [H,h,gscale,PDC]=inK_2D_meshgrid(ranges,positions,subdiv)
% [k,y]=inK(ranges,positions,subdiv)
% Garncarek measure of spatial inhomogenity
% ranges = [min(x) max(x);min(y) max(y);min(z) max(z)]; % in nm
% positions = [x y z] n-by-3, in nm
% subdiv = max number of sub-divisions
pix = min(ranges(:,2)-ranges(:,1))/(2^subdiv) % voxel length in nm
s = prod(ranges(:,2)-ranges(:,1))/(pix^2); % volume expressed in the smallest unit cell
%generate families of Population distribution charts (PDCs)
PDC = cell(1,subdiv+1);
lat = cell(1,subdiv+1);
n = size(positions,1); % total number of objects
h = zeros(1,subdiv+1); % measure h of the degree of inhomogeneity
H = zeros(3,subdiv+1); % improved 3-sigma test = (h-E(h))/sigma(h)
gscale = zeros(1,subdiv+1);
for k=0:subdiv
    % generate reference lattice
    lx = (ranges(1,1):(pix*2^k):ranges(1,2))+(pix*2^(k-1));
    ly = (ranges(2,1):(pix*2^k):ranges(2,2))+(pix*2^(k-1));
    %lz = ranges(3,1):(pix*2^k):ranges(3,2);
    [x,y]=meshgrid(lx,ly);
    lat{k+1} = [x(:) y(:)]; % list
    [idx,~]=knnsearch(lat{k+1},positions); % which cell is each cluster nearest
    [ni]=hist(idx,1:size(lat{k+1},1));
    PDC{k+1} = reshape(ni,[length(lx) length(ly)]);
    % end of data transformation
    K = length(lat{k+1}); % number of cells in PDC
    gscale(k+1) = s/K; % greater scale from 1 (smallest) -> s
    h(k+1) = (-n/(K-1))+(K/(n*(K-1)))*sum(ni.^2);
    H(1,k+1) = -sqrt((n*(K-1))/(2*(n-1))); % min H
    H(2,k+1) = sqrt((n*(K-1))/(2*(n-1)))*(((1-n-K)/(K-1)) + (K/(n*(K-1)))*sum(ni.^2) );
    H(3,k+1) = 0.5*sqrt(2*n*(n-1)*(K-1)); % max H
end

