function [H,h,gscale,PDC]=inK_2D(ranges,positions,subdiv)
% [H,h,gscale,PDC]=inK_2D(ranges,positions,subdiv)
% Garncarek measure of spatial inhomogenity
% ranges = [min(x) max(x);min(y) max(y);min(z) max(z)]; % in nm
% positions = [x y z] n-by-3, in nm
% subdiv = max number of sub-divisions
positions = positions-repmat(min(ranges'),size(positions,1),1);
l = ranges(:,2)-ranges(:,1); % lengths
pix = min(l)/(2^subdiv); % voxel length in nm
s = prod(l)/(pix^2); % volume expressed in the smallest unit cell

%generate families of Population distribution charts (PDCs)
PDC = cell(1,subdiv+1);
n = size(positions,1); % total number of objects
h = zeros(1,subdiv+1); % measure h of the degree of inhomogeneity
H = zeros(1,subdiv+1); % improved 3-sigma test = (h-E(h))/sigma(h)
gscale = zeros(1,subdiv+1);
for k=0:subdiv
    % generate reference lattice
    lk = ceil(l./(pix*2^k)); % length in unit cells of each x,y & z
    ii = floor(positions./(pix*2^k))+1; % [ix iy iz] indicies
    iii = sub2ind(lk',ii(:,1),ii(:,2)); % linear indicies
    PDC{k+1} = accumarray(iii,1,[],@sum,0,true); % sparse, sums of 'hits'
    % end of data transformation
    K = prod(lk);
    %gscale(k+1) = s/K; % greater scale from 1 (smallest) -> s
    gscale(k+1) = (pix*2^k); % current voxel Size
    h(k+1) = (-n/(K-1))+(K/(n*(K-1)))*full(sum(PDC{k+1}.^2));
    H(k+1) = sqrt((n*(K-1))/(2*(n-1)))*(((1-n-K)/(K-1)) + (K/(n*(K-1)))*full(sum(PDC{k+1}.^2)) );
end

