% inhomogeneity examples

% clusters of clusters (points)
ranges = [0 600;0 600;0 600]; % in nm

num_clusters = 20;
centres = rand(num_clusters,3); % centres of the clusters (normalised)
radii = [ones(num_clusters,1)*5 ones(num_clusters,1)*15 ones(num_clusters,1)*30 ones(num_clusters,1)*60]; % radii of clusters

%pointDensity = 1E-4; % points per nm3
pointN = 20;
subdivs = 16;
Hcell = zeros(subdivs-1,size(radii,2));
hcell = zeros(subdivs-1,size(radii,2));
xcell = zeros(subdivs-1,size(radii,2));
totalPoints = cell(size(radii,2),1);
for k = 1:size(radii,2)
    r = radii(:,k);
    ranges2 = [ranges(:,1)+max(r) ranges(:,2)-max(r)];
    rng('default');
    centres = rand(num_clusters,3); % centres of the clusters (normalised)
    rng('shuffle');
    centres = centres.*repmat((max(ranges2,[],2)-min(ranges2,[],2))',size(centres,1),1);
    centres = centres + repmat(min(ranges2,[],2)',size(centres,1),1);
    
    pointCell = cell(num_clusters,1);
    for i=1:size(centres,1)
        %[x,y,z]=randsphere(round(pointDensity*(4*pi/3)*(radii(i)^3)),radii(i));
        [x,y,z]=randsphere(pointN,r(i));
        pointCell{i} = [x y z]+repmat(centres(i,:),size(x,1),1);
    end
    totalPoints{k} = vertcat(pointCell{:});
    [Hcell(:,k),hcell(:,k),xcell(:,k),PDC]=inK(ranges,totalPoints{k},subdivs,1);
end
subplot(1,2,1)
plot(xcell,Hcell)
xlabel('Scale nm');
ylabel('H');
xlim([0 xcell(end-1,1)])
p = [3,4,7,8]; %subplot positions
c = {'b','g','r','c'}; c=strcat(c,'.');
for i = 1:4
    subplot(2,4,p(i));
    scatter3(totalPoints{i}(:,1),totalPoints{i}(:,2),totalPoints{i}(:,3),c{i});
    axis equal
    camproj('perspective')
end