% inhomogeneity examples

% clusters of clusters (points)
ranges = [0 400;0 400;0 400]; % in nm
rng('default');
num_clusters = 20;
centres = rand(num_clusters,3); % centres of the clusters (normalised)
radii = rand(num_clusters,1)*0+30; % radii of clusters
rng('shuffle');
%pointDensity = 1E-4; % points per nm3
pointN = 30;

ranges2 = [ranges(:,1)+max(radii) ranges(:,2)-max(radii)];
centres = centres.*repmat((max(ranges2,[],2)-min(ranges2,[],2))',size(centres,1),1);
centres = centres + repmat(min(ranges2,[],2)',size(centres,1),1);

pointCell = cell(num_clusters,1);
for i=1:size(centres,1)
    %[x,y,z]=randsphere(round(pointDensity*(4*pi/3)*(radii(i)^3)),radii(i));
    [x,y,z]=randsphere(pointN,radii(i));
    pointCell{i} = [x y z]+repmat(centres(i,:),size(x,1),1);
end
points = vertcat(pointCell{:});

[H,h,gscale,PDC]=inK(ranges,points,16,1);
subplot(1,2,1);
plot(gscale,H);
xlabel('gscale nm');
ylabel('H');
subplot(1,2,2);
scatter3(points(:,1),points(:,2),points(:,3),'.'); axis equal

%% remove spheres from even random points
figure
points = rand(2000,3)*400;
rng('default');
centres = rand(10,3)*400;
radii = 120;
[idx,d]=knnsearch(centres,points);
pointsRemoved = points(d>radii,:);
[H,h,gscale,PDC]=inK(ranges,pointsRemoved,16,1);
subplot(1,2,1);
plot(gscale,H);
xlabel('gscale nm');
ylabel('H');
subplot(1,2,2);
scatter3(pointsRemoved(:,1),pointsRemoved(:,2),pointsRemoved(:,3),'.'); axis equal