function [ hit ] = hitTest( p, pmin, pmax )
%HITTEST checks if p is within a box whose corners are defined by pmin and
%pmax. This test should generalise for n-dimensions of p
%   p, pmax and pmin must be col or row vectors with the corresponding
%   coordinates, eg:
%   p = [2 4 9] % x,y,z of point
%   pmin = [0 0 0] % x,y,z of smallest corner
%   pmax = [10 10 10] % x,y,z of largerst corner
%   hit = 1;
if(~sum(~(p>pmin)))
    hit = ~sum(~(p<=pmax));
end

end

