function [ h ] = h2dVoronoi( x,y )
% h = h2d(s)
%   h is a function normalised between 0 and 1 that gives and objective
%   measure of the inhomogenity of spatial data based on the deviation of a
%   grid density from a mean density. See "Measuring Inhomogeneity in 
%   Spatial Distributions", Udo Schilcher et Al. 
%   978-1-4244-1645-5/08/$25.00 2008 IEEE
% Matlab implimentation A. London May 2013 

% alogrithm for segmentation or 'meshing':
% split each linear dimension in half
% check the number of nodes in each segment
% if > 1 then repeat for that segment
xtent = range(x); % bad pun
ytent = range(y); % extent of y
A = xtent*ytent;
n = length(x); % number of nodes
if(n ~= length(y))
    error('x and y not same length');
end
d = n/A; % mean density
h = 0;

[V,C] = voronoin([x y]); % voronoi verts and cells (inc edge cells)
% Need to check V to see which points lie outside of the delaunay tess. of
% the whole set of points.
% TODO

icount = 1;
extcount = 1;
volume = 0;
% find edge and centre cells
for i = 1:length(C) 
    if all(C{i}~=1)   
        % If at least one of the indices is 1,
        % then it is an open region and we can't
        % patch that.
        %cint(:,:,icount) = [V(C{i},1) V(C{i},2)];
        
        dt = DelaunayTri([V(C{i},1) V(C{i},2)]);
        [qhull AV] = convexHull(dt);
        volume(icount) = AV; % area or volume of the cell
        patch(V(C{i},1),V(C{i},2),i); % use color i.
        icount = icount + 1;
    else
       %cext(:,:,extcount) =  [V(C{i},1)  V(C{i},2)];
       extcount = extcount + 1;
    end
end
% total volume
dt = DelaunayTri([[x;V(2:end,1)] [y;V(2:end,2)]]);
%dt = DelaunayTri([x y]);
[qhull AV] = convexHull(dt);
volumeTotal = AV;
ad = AV/n;
id = sum(abs((1./volume)-ad));
ed = abs(extcount/(AV-sum(volume))-ad);
h = (1/(2*n))*(id+ed)

if(0)
% find shortest distance
dx = min(diff(sort(x)));
dy = min(diff(sort(y)));

% make grid
%[sx, sy] = meshgrid(min(x):dx:max(x)+dx,min(y):dy:max(y)+dy);
%[sxn, syn] = size(sx);
sxn = round((max(x)-min(x))/dx);
syn = round((max(y)-min(y))/dy);

if(sxn>syn)
    r = ceil(log2(sxn));
else
    r = ceil(log2(syn));
end
const = 0;
for j = 1:r
    const = const + 4.79129^(1-j);
end

nodefree = sxn*syn - n; % assuming one node per grid, or zero
h = h + nodefree*d;
h = h + abs((1/dx*dy)-d)*n;
h = h*(1/(2*n))

% for ix = 1:sxn
%     for iy = 1:syn
%         
%     end
% end
% n = number of nodes
% compute the average density = n/range of the nodes
% ie, n/total area/volume
% h = (1/2n).(area).sum over all segments of the unsigned difference between
% the measured density and the average density
end
end
