% IVAS lineprofile plot
% plot line profiles exported from IVAS in the csv form
filename1 = 'C:\Users\andy\APT\R14_18225\prof_lower.csv';
filename2 = 'C:\Users\andy\APT\R14_18225\prof_top.csv';
e = {'Y','Ti','O','Cr'}; % elements to plot
lineSpec = {'b-','g-','r-','m-'}; % line specification
m = {'Fe'}; % matrix main, eg. Fe
mm = {'Cr'}; % matrix minor eg. Cr
mmCont = 0.11; % minor concentration in matrix
% Default percentages
% 1
[dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename1);
subplot(2,2,1)
i = 1;
plot(dist,elePer(:,strcmp(e(i),elements)),lineSpec{i});
hold on
for i = 2:length(e)
    plot(dist,elePer(:,strcmp(e(i),elements)),lineSpec{i});
end
hold off
legend(e);title('"Unirradiated"');ylabel('Composition');
% 2
[dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename2);
subplot(2,2,3)
i = 1;
plot(dist,elePer(:,strcmp(e(i),elements)),lineSpec{i});
hold on
for i = 2:length(e)
    plot(dist,elePer(:,strcmp(e(i),elements)),lineSpec{i});
end
hold off
title('Low T Irradiated');
xlabel('Distance nm');ylabel('Composition');

% Matrix corrected
if(0)
% 1*
[dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename1);
% convert to counts
counts = elePer.*repmat(atomCount,[1 size(elePer,2)]);
% remove matrix
counts(:,strcmp(mm,elements)) = counts(:,strcmp(mm,elements))-counts(:,strcmp(m,elements))*mmCont;
%counts(:,strcmp(m,elements)) = 0; % set major matrix to 0
counts(counts(:,strcmp(mm,elements))<0,strcmp(mm,elements)) = 0; % remove negatives
%matCorPer = counts./repmat(sum(counts,2),[1 size(counts,2)]);
matCorPer = counts./repmat(atomCount,[1 size(counts,2)]);
subplot(2,2,2)
i = 1;
plot(dist,matCorPer(:,strcmp(e(i),elements)),lineSpec{i});
hold on
for i = 2:length(e)
    plot(dist,matCorPer(:,strcmp(e(i),elements)),lineSpec{i});
end
hold off
legend(e);title('"Unirradiated" Matrix Corrected Cr');ylabel('Composition');

% 2*
[dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename2);
% convert to counts
counts = elePer.*repmat(atomCount,[1 size(elePer,2)]);
% remove matrix
counts(:,strcmp(mm,elements)) = counts(:,strcmp(mm,elements))-counts(:,strcmp(m,elements))*mmCont;
%counts(:,strcmp(m,elements)) = 0; % set major matrix to 0
counts(counts(:,strcmp(mm,elements))<0,strcmp(mm,elements)) = 0; % remove negatives
%matCorPer = counts./repmat(sum(counts,2),[1 size(counts,2)]);
matCorPer = counts./repmat(atomCount,[1 size(counts,2)]);
subplot(2,2,4)
i = 1;
plot(dist,matCorPer(:,strcmp(e(i),elements)),lineSpec{i});
hold on
for i = 2:length(e)
    plot(dist,matCorPer(:,strcmp(e(i),elements)),lineSpec{i});
end
hold off
title('Low T Irradiated  Matrix Corrected Cr');
xlabel('Distance nm');ylabel('Composition');
end

% Matrix Counts
if(1)
% 1*
[dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename1);
% convert to counts
counts = elePer.*repmat(atomCount,[1 size(elePer,2)]);
subplot(2,2,2)
%plot(dist,counts(:,strcmp(m,elements)),'k-');
plot(dist,atomCount,'k-');
hold on
for i = 1:length(e)
    plot(dist,counts(:,strcmp(e(i),elements)),lineSpec{i});
end
hold off
legend(['Total' e]);title('"Unirradiated" Counts');ylabel('Counts');

% 2*
[dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename2);
% convert to counts
counts = elePer.*repmat(atomCount,[1 size(elePer,2)]);
subplot(2,2,4)
%plot(dist,counts(:,strcmp(m,elements)),'k-');
plot(dist,atomCount,'k-');
hold on
for i = 1:length(e)
    plot(dist,counts(:,strcmp(e(i),elements)),lineSpec{i});
end
hold off
title('Low T Irradiated  Counts');
xlabel('Distance nm');ylabel('Counts');
end