function [dist,ionCount,atomCount,ionicPer,ionicErr,elements,elePer,eleErr] = IVASprofileImport(filename)
%[dist,ionCount,atomCount,ionicPer,ionicErr,elePer,eleErr] = IVASprofileImport(filename)
% Takes a csv file exported from IVAS and decomposed the ionic percentages
% into elemental percentages. The errors are also reported ionicErr and
% eleErr.
% Needs csv2cell.m from the file exchange
% A London Dec 2013
if ~exist(filename,'file')
    error(strcat('File:',filename,' not found'));
end
m = csv2cell(filename,'fromfile');
numIons = (length(m(1,:))-3)/2;
ions = cell(numIons,1);
for i = 1:numIons
    ions{i} = m{1,3+i}(1:regexp(m{1,3+i},'\s')-1);
end

% convert natural names into a element matrix
[ionTable,elements]=ions2ionTable(ionStr2ions(ions));

% convert cell to matrix
ionicPer = cellfun(@str2double,m(2:end,4:(3+numIons)))/100;
ionicErr = cellfun(@str2double,m(2:end,(4+numIons):end))/100;

% get counts
ionCount = cellfun(@str2double,m(2:end,2));
atomCount = cellfun(@str2double,m(2:end,3));
% get distance
dist = cellfun(@str2double,m(2:end,1));
% do decomposition
elePer = ionicPer*ionTable;
eleErr = ionicErr*ionTable;
end