function icf = ICFestimate(D,thetaCryst)
%icf = ICFestimate(Detector distance,known thetaCryst in degrees)
L = 44.1969; % flight length in mm
%D = sqrt(Dx^2 + Dy^2); % detector distance
tD = atan(D/L); % thetaDet
sd = sin(tD);
cd = cos(tD);
syms m
% solve using the equation in the orange book  (appendix C, pg 269)
icf = double(solve( (m*sd*cd+sd*sqrt(1-m^2*sd^2))/(m*sd^2+cd*sqrt(1-m^2*sd^2)) == tand(thetaCryst), m));
end