function [outputData,cols]=GIXdataBase(string,usableFlag)
%[outputData,columnNames]=dataBase(string,usableFlag)
%Returns info from data.mat based on the args (string) provided.
% Example: dataBase('usable==1') returns all usable datasets.
% 'mat==C3' returns all samples with the C3 mat code.
% Allowed operators: == != > >= < <=
% == and != only work with string fields
% columns in GIXdata.mat:
% cols = {'ID','Name','matCode','mat','irrdT1','irrdDpa1','irrdT2', ...
%    'irrdDpa2','tilt','time','file','lambda','attnLength','usable'};
% cols is now stored in the GIXdata.mat file and returned
% line 35 = an example of column data types
% A London July 2014

% need to add cluster files, pos locations etc to this

% get database data
load('GIXdata.mat','GIXdata','cols'); % loads 'GIXdata' and 'cols'
data = GIXdata;
% complete row (don't change this!) used to get data type str/num
rt = 35;
% get options
if ~exist('usableFlag','var')
    usableFlag = 0;
end
% get item names
items = regexp(string,'(\w+)','match');
if length(items)~=2
    error('badly formed input');
end
oper = regexp(string,'(\w+)','split');
if length(oper)~=3
    error('badly formed input');
end
oper = oper{2}; % operation to perform

c = strcmp(cols,items{1});
% check item exists in the column name list
if ~sum(strcmp(cols,items{1}))
    error(strcat('Could not find:',items{1},' in column name list'));
end

%get type of col: str/double
if isnumeric(data{rt,c})
    % number
    sf = 0; % string-flag
elseif ischar(data{rt,c})
    % str
    sf = 1;
else
   error('Couldnt match item to column name') 
end
% get acceptable list
if strcmp(oper,'==') || strcmp(oper,'=')
    if sf % is string
        p=strcmp( data(:,c), items{2} );
    else % is number
        p= cell2mat(data(:,c))==str2double(items{2});
    end
elseif strcmp(oper,'>=')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))>=str2double(items{2});
    end
elseif strcmp(oper,'>')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))>str2double(items{2});
    end
elseif strcmp(oper,'<')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))<str2double(items{2});
    end
elseif strcmp(oper,'<=')
    if sf % is string
        error(strcat(oper,' not possible with string arguments'));
    else % is number
        p= cell2mat(data(:,c))<=str2double(items{2});
    end
elseif strcmp(oper,'!=') || strcmp(oper,'~=')
    if sf % is string
        p=~strcmp( data(:,c), items{2} );
    else % is number
        p=cell2mat(data(:,c))~=str2double(items{2});
    end
else
    error(strcat('Unrecognised operation:',oper));
end

outputData = data(p,:);
if usableFlag
    outputData=outputData(cell2mat(outputData(:,end))==1,:);
end