angles = [0.25,0.50,0.7,1,1.25,1.50,1.75,2,2.25,2.5,2.75,3,4];
attnDepth = [45,183,286,394,493,599,697,802,899,1005,1102,1207,1610]; % nm
eref = [45,505.767747900000;183,1465.02833000000;286,2033.66590700000;394,2694.22684300000;493,2919.96834600000;599,2929.84916700000;802,3134.91570300000;899,4238.72002400000;1005,3751.00884500000;1207,3571.62408700000;1610,3450.12073100000;];
eA = [183,1.29000000000000e-07;394,107.800242900000;493,227.556288850000;599,526.345819500000;697,768.908503500000;802,839.350540000000;1207,1630.58422850000;1610,1589.15348350000];
mu = 4.33935E-05; % in nm-1
I = 1;
l = 3; % sample dimensions in mm
bw = 2.5; % beam width in mm
bh = 0.08; % beam height in mm
tT = 16.3; % two theta in degrees
tT = tT*pi/180; % radians
% damage depth
dmgDepth = 1900; % in nm
dmgDepthA = 900; % in nm
% ref signal
refSig = zeros(size(angles));
refSig2 = refSig;
sampSig = zeros(size(angles));
sampASig = zeros(size(angles));
for i=1:length(angles)
    area = min(bh/sin(angles(i)*pi/180),l)*bw;
    k = 1/attnDepth(i) + mu/sin(tT-(angles(i)*pi/180));
    k2 = mu/sin(angles(i)*pi/180) + mu/sin(tT-(angles(i)*pi/180));
    refSig(i) = area*I/k;
    refSig2(i) = area*I/k2;
    sampSig(i) = area*I*exp(-dmgDepth*k)/k;
    sampASig(i) = area*I*exp(-dmgDepthA*k)/k;
end
figure(1)
plot(attnDepth,refSig,'k-',attnDepth,sampASig,'r-',attnDepth,sampSig,'b-',eref(:,1),eref(:,2),'kx',eA(:,1),eA(:,2),'rx');
legend('ref','A','B','Exp Ref','Exp A')
% figure(2)
% plot(attnDepth,sampASig./refSig,'r-',attnDepth,sampSig./refSig,'b-')
% legend('A','B');