% Integrate the signal between a set of points
root = 'C:\Users\andy\Documents\DIAMOND-AJL\';
fitBetween = [13.5 14.5; 15.5 15.75; 15.9 16.6; 16.75 17]; % n-rows, 2-columns
plotBetween = [13 18];
% which files to plot as sub-plots?
%subplots = [15 17 18 19 20 23 24; 6 7 8 9 11 12 13]-1;
%subplots = [19 6 1 3; 23 10 2 4];
%subplots = [1:12; 13:23 23];
subplots = [1:4];
files = dir(strcat(root,'*.xye'));
C={files.name}';
num_files = length(C);
% for storing the results:
intSignal = zeros(num_files,size(fitBetween,1)); % a-param, gradient, intercept of theoretical twotheta and calculated tt
px = cell(num_files,1);
py = cell(num_files,1);
for i=1:num_files
    % import
    [tt,y]=GIX_import(strcat(root,C{i}));
    for j = 1:size(fitBetween,1)
        intSignal(i,j) = sum(y(tt > fitBetween(j,1) & tt < fitBetween(j,2)));
    end
    px{i} = tt(tt > plotBetween(1) & tt < plotBetween(2));
    py{i} = y(tt > plotBetween(1) & tt < plotBetween(2));
end
ii = 1;
for i=1:size(subplots,1)
    for j=1:size(subplots,2)
        subplot(size(subplots,1),size(subplots,2),ii);
        ii = ii +1;
        plot(px{subplots(i,j)},py{subplots(i,j)},'b-');
        ylim([100 600]);
        title(C{subplots(i,j)},'Interpreter', 'none');
    end
end